/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.java;

public class LiteralParser {
    public static boolean denotesLong(String s) {
        char c = s.charAt(s.length() - 1);
        return c == 'l';
    }

    public static boolean denotesFloat(String s) {
        char c = s.charAt(s.length() - 1);
        return c == 'f';
    }

    public static Double parseDouble(String s) {
        if (s.charAt(s.length() - 1) == 'd') {
            s = s.substring(0, s.length() - 1);
        }
        return Double.valueOf(s);
    }

    public static Float parseFloat(String s) {
        if (s.charAt(s.length() - 1) == 'f') {
            s = s.substring(0, s.length() - 1);
        }
        return Float.valueOf(s);
    }

    public static long parseLong(String s) {
        long n;
        block3: {
            block4: {
                if (s.charAt(s.length() - 1) == 'l') {
                    s = s.substring(0, s.length() - 1);
                }
                int l = s.length();
                n = 0L;
                if (l == 0) break block3;
                if (l != 1 && s.charAt(1) == 'x') break block4;
                long f = 1L;
                long base = s.charAt(0) == '0' ? 8L : 10L;
                for (int i = l - 1; i >= 0; --i) {
                    n += f * (long)(s.charAt(i) - 48);
                    f *= base;
                }
                break block3;
            }
            if (s.charAt(1) == 'x') break block3;
            long f = 1L;
            for (int i = l - 1; i >= 0; --i) {
                char c = s.charAt(i);
                n = LiteralParser.denotesDigit(c) ? (n += f * (long)(s.charAt(i) - 48)) : (n += f * (long)(10 + s.charAt(i) - 97));
                f *= 16L;
            }
        }
        return n;
    }

    public static int parseInt(String s) {
        return (int)LiteralParser.parseLong(s);
    }

    public static boolean denotesDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean denotesHexDigit(char c) {
        return c >= '0' && c <= '7';
    }

    public static String parseString(String s) {
        StringBuffer out = new StringBuffer();
        for (int i = 1; i < s.length() - 1; ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                if (LiteralParser.denotesHexDigit(c = s.charAt(++i))) {
                    int n = c - 48;
                    if (c <= '3') {
                        if (LiteralParser.denotesHexDigit(s.charAt(i + 1))) {
                            n = n * 8 + (s.charAt(i + 1) - 48);
                            if (LiteralParser.denotesHexDigit(s.charAt(++i + 1))) {
                                n = n * 8 + (s.charAt(i + 1) - 48);
                                ++i;
                            }
                        }
                    } else if (LiteralParser.denotesHexDigit(s.charAt(i + 1))) {
                        n = n * 8 + (s.charAt(i + 1) - 48);
                        ++i;
                    }
                    out.append((char)n);
                    continue;
                }
                switch (c) {
                    case 'n': {
                        out.append('\n');
                        break;
                    }
                    case 't': {
                        out.append('\t');
                        break;
                    }
                    case 'b': {
                        out.append('\b');
                        break;
                    }
                    case 'r': {
                        out.append('\r');
                        break;
                    }
                    case 'f': {
                        out.append('\f');
                        break;
                    }
                    case '\\': {
                        out.append('\\');
                        break;
                    }
                    case '\'': {
                        out.append('\'');
                        break;
                    }
                    case '\"': {
                        out.append('\"');
                        break;
                    }
                    default: {
                        out.append(c);
                        break;
                    }
                }
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    public static char parseChar(String s) {
        return LiteralParser.parseString(s).charAt(0);
    }
}

