/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.java;

import de.renew.expression.CallExpression;
import de.renew.expression.EqualsExpression;
import de.renew.expression.Expression;
import de.renew.expression.Function;
import de.renew.expression.InvertibleExpression;
import de.renew.expression.ListExpression;
import de.renew.expression.LocalVariable;
import de.renew.expression.NoArgExpression;
import de.renew.expression.NoArgFunction;
import de.renew.expression.TupleExpression;
import de.renew.expression.TypeCheckingExpression;
import de.renew.expression.VariableExpression;
import de.renew.formalism.function.ArrayFunction;
import de.renew.formalism.function.ArrayWriteFunction;
import de.renew.formalism.function.CastFunction;
import de.renew.formalism.function.ConstructorFunction;
import de.renew.formalism.function.DynamicConstructorFunction;
import de.renew.formalism.function.DynamicFieldFunction;
import de.renew.formalism.function.DynamicFieldWriteFunction;
import de.renew.formalism.function.DynamicMethodFunction;
import de.renew.formalism.function.DynamicStaticMethodFunction;
import de.renew.formalism.function.Executor;
import de.renew.formalism.function.FieldFunction;
import de.renew.formalism.function.FieldWriteFunction;
import de.renew.formalism.function.Identity;
import de.renew.formalism.function.MethodFunction;
import de.renew.formalism.function.StaticFieldFunction;
import de.renew.formalism.function.StaticFieldWriteFunction;
import de.renew.formalism.function.StaticMethodFunction;
import de.renew.formalism.java.ConstructorSuggestion;
import de.renew.formalism.java.ExtendedParseException;
import de.renew.formalism.java.FieldSuggestion;
import de.renew.formalism.java.MethodSuggestion;
import de.renew.formalism.java.ParseException;
import de.renew.formalism.java.ParsedDeclarationNode;
import de.renew.formalism.java.PrimaryPart;
import de.renew.formalism.java.Token;
import de.renew.formalism.java.TypedExpression;
import de.renew.formalism.java.VariableSuggestion;
import de.renew.util.Types;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public final class JavaHelper {
    public static final String KNOWN_METHODS = "\nKnown methods:";
    public static final String KNOWN_FIELDS = "\nKnown fields:";
    private static Logger _logger = Logger.getLogger(JavaHelper.class);
    private static final String ERROR_LINE_PREFIX = "Error in line ";
    private static final String COLUMN_PREFIX = ", column ";
    private static final String MESSAGE_SUFFIX = ":\n";
    private static final String TYPE_MISMATCH_ERROR = "Operator types do not match.";
    private static final String VOID_TYPE_ERROR = "Expression of type void not allowed here.";
    private static final String TO = " to ";
    private static final String PERIOD = ".";
    private static final String INVALID_LEFT_HAND_SIDE = "Invalid left hand side of assignment.";
    private static final String NO_SUCH_VARIABLE = "No such variable: ";
    private static final String ENCOUNTERED = "Encountered ";
    private static final String DECLARED_IN = " declared in ";
    private static final String MALFORMED_PRIMARY_VECTOR = "Malformed primary vector.";
    private static final String INIT = "<init>";
    private static final String DUE_TO = " due to ";
    private static final String COLON = ": ";
    private static final String MULTIPLE_METHODS_MATCH = "Multiple methods match: ";
    private static final String CANNOT_NOT_BIND_METHOD = "Cannot not bind method ";
    private static final String LOADING_CLASS = "Could not load class ";
    private static final String NO_SUCH_CLASS_OR_VARIABLE = "No such class or variable.";
    private static final String NOT_AN_ARRAY = "Not an array.";
    private static final String NO_SUCH_FIELD = "No such field.";
    private static final String NO_SUCH_STATIC_FIELD = "No such static field: ";

    private JavaHelper() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static Logger getLogger() {
        return _logger;
    }

    public static void setLogger(Logger newLogger) {
        _logger = newLogger;
    }

    public static String buildErrorMessage(String msg, Token token) {
        if (token != null) {
            Token posToken = token.next == null ? token : token.next;
            return ERROR_LINE_PREFIX + posToken.beginLine + COLUMN_PREFIX + posToken.beginColumn + MESSAGE_SUFFIX + msg;
        }
        return msg;
    }

    public static ParseException makeParseException(String msg, Token token) {
        if (token != null) {
            ParseException ex = new ParseException(JavaHelper.buildErrorMessage(msg, token));
            ex.currentToken = token;
            return ex;
        }
        return new ParseException(msg);
    }

    public static ExtendedParseException makeExtendedParseException(String msg, Object o, Token token) {
        if (token != null) {
            ExtendedParseException ex = new ExtendedParseException(JavaHelper.buildErrorMessage(msg, token), o);
            ex.currentToken = token;
            return ex;
        }
        return new ExtendedParseException(msg, o);
    }

    public static TypedExpression makeTypedBinary(TypedExpression left, TypedExpression right, Function fun, Class<?> type) {
        return new TypedExpression(type, (Expression)new CallExpression(type, (Expression)new TupleExpression(left.getExpression(), right.getExpression()), fun));
    }

    public static TypedExpression makeBooleanBinary(TypedExpression left, TypedExpression right, Function fun) {
        return JavaHelper.makeTypedBinary(left, right, fun, Boolean.TYPE);
    }

    public static TypedExpression makeBinary(TypedExpression left, TypedExpression right, Function fun, Token errToken) throws ParseException {
        Class<?> type = JavaHelper.determineBinaryType(left, right, errToken);
        return JavaHelper.makeTypedBinary(left, right, fun, type);
    }

    private static Class<?> determineBinaryType(TypedExpression left, TypedExpression right, Token errToken) throws ParseException {
        Class<?> rightType;
        if (!left.isTyped() || !right.isTyped()) {
            return Types.UNTYPED;
        }
        Class<?> leftType = left.getType();
        if (JavaHelper.isBooleanType(leftType, rightType = right.getType(), errToken)) {
            return Boolean.TYPE;
        }
        return JavaHelper.determineNumericType(leftType, rightType);
    }

    private static boolean isBooleanType(Class<?> leftType, Class<?> rightType, Token errToken) throws ParseException {
        if (leftType == Boolean.TYPE || rightType == Boolean.TYPE) {
            if (leftType != Boolean.TYPE || rightType != Boolean.TYPE) {
                throw JavaHelper.makeParseException(TYPE_MISMATCH_ERROR, errToken);
            }
            return true;
        }
        return false;
    }

    private static Class<?> determineNumericType(Class<?> leftType, Class<?> rightType) {
        if (leftType == Double.TYPE || rightType == Double.TYPE) {
            return Double.TYPE;
        }
        if (leftType == Float.TYPE || rightType == Float.TYPE) {
            return Float.TYPE;
        }
        if (leftType == Long.TYPE || rightType == Long.TYPE) {
            return Long.TYPE;
        }
        return Integer.TYPE;
    }

    public static Class<?> unaryNumericPromotion(Class<?> old, Token errToken) throws ParseException {
        if (old == Types.UNTYPED) {
            return old;
        }
        if (old == null || !old.isPrimitive()) {
            throw JavaHelper.makeParseException("Primitive type expected.", errToken);
        }
        if (old == Boolean.TYPE) {
            throw JavaHelper.makeParseException("Numeric type expected.", errToken);
        }
        if (old == Byte.TYPE || old == Short.TYPE || old == Character.TYPE) {
            return Integer.TYPE;
        }
        return old;
    }

    public static Class<?> unaryIntegralPromotion(Class<?> old, Token errToken) throws ParseException {
        if (old == Float.TYPE || old == Double.TYPE) {
            throw JavaHelper.makeParseException("Integral type expected.", errToken);
        }
        return JavaHelper.unaryNumericPromotion(old, errToken);
    }

    public static void ensureNonVoid(TypedExpression expr, Token errToken) throws ParseException {
        if (expr.getType() == Void.TYPE) {
            throw JavaHelper.makeParseException(VOID_TYPE_ERROR, errToken);
        }
    }

    public static void ensureConvertability(Class<?> clazz, TypedExpression expr, Token errToken) throws ParseException {
        if (expr.isTyped() && !Types.allowsWideningConversion(expr.getType(), clazz)) {
            throw JavaHelper.makeParseException("Cannot convert " + JavaHelper.makeTypeErrorString(expr.getType()) + TO + JavaHelper.makeTypeErrorString(clazz) + PERIOD, errToken);
        }
    }

    public static void ensureEnumerateability(TypedExpression expr, Token errToken) throws ParseException {
        if (expr.isTyped() && (expr.getType() == null || !expr.getType().isPrimitive() || expr.getType() == Double.TYPE || expr.getType() == Float.TYPE)) {
            throw JavaHelper.makeParseException("Enumerable type expected.", errToken);
        }
    }

    public static void ensureBinaryMatch(TypedExpression left, TypedExpression right, Token errToken) throws ParseException {
        if (left.isTyped() && right.isTyped()) {
            boolean rightRef;
            Class<?> leftType = left.getType();
            Class<?> rightType = right.getType();
            boolean leftRef = leftType == null || !leftType.isPrimitive();
            boolean bl = rightRef = rightType == null || !rightType.isPrimitive();
            if (leftRef ^ rightRef) {
                throw JavaHelper.makeParseException(TYPE_MISMATCH_ERROR, errToken);
            }
            if (leftType == Boolean.TYPE ^ rightType == Boolean.TYPE) {
                throw JavaHelper.makeParseException(TYPE_MISMATCH_ERROR, errToken);
            }
        }
    }

    public static TypedExpression makeExplicitCastExpression(Class<?> clazz, TypedExpression expr, Token errToken) throws ParseException {
        if (expr.getType() == clazz) {
            return expr;
        }
        if (!expr.isTyped()) {
            if (clazz.isPrimitive()) {
                return new TypedExpression(clazz, (Expression)new CallExpression(clazz, expr.getExpression(), (Function)new CastFunction(clazz)));
            }
            return new TypedExpression(clazz, (Expression)new TypeCheckingExpression(clazz, expr.getExpression()));
        }
        if (Types.allowsCast(expr.getType(), clazz)) {
            if (clazz.isPrimitive()) {
                if (expr.getType() == null) {
                    return new TypedExpression(clazz, expr.getExpression());
                }
                if (Types.allowsLosslessWidening(expr.getType(), clazz)) {
                    return new TypedExpression(clazz, (Expression)new InvertibleExpression(clazz, expr.getExpression(), (Function)new CastFunction(clazz), (Function)new CastFunction(expr.getType())));
                }
                return new TypedExpression(clazz, (Expression)new CallExpression(clazz, expr.getExpression(), (Function)new CastFunction(clazz)));
            }
            return new TypedExpression(clazz, (Expression)new TypeCheckingExpression(clazz, JavaHelper.makeGuardedExpression(expr)));
        }
        throw JavaHelper.makeParseException("Cannot cast " + Types.typeToString(expr.getType()) + TO + Types.typeToString(clazz) + PERIOD, errToken);
    }

    public static Expression[] makeExpressionArray(Vector<TypedExpression> vector) {
        Expression[] result = new Expression[vector.size()];
        for (int i = 0; i < result.length; ++i) {
            TypedExpression expr = vector.elementAt(i);
            result[i] = expr.getExpression();
        }
        return result;
    }

    public static TupleExpression makeTupleExpression(Vector<TypedExpression> vector) {
        return new TupleExpression(JavaHelper.makeExpressionArray(vector));
    }

    public static ListExpression makeListExpression(Vector<TypedExpression> vector, boolean tailed) {
        return new ListExpression(JavaHelper.makeExpressionArray(vector), tailed);
    }

    public static Expression makeGuardedExpression(TypedExpression expr) {
        if (expr.isTyped() && expr.getType() != null) {
            return new TypeCheckingExpression(expr.getType(), expr.getExpression());
        }
        return expr.getExpression();
    }

    public static TupleExpression makeGuardedTupleExpression(Vector<TypedExpression> vector) {
        Expression[] result = new Expression[vector.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = JavaHelper.makeGuardedExpression(vector.elementAt(i));
        }
        return new TupleExpression(result);
    }

    public static Class<?>[] makeTypeArray(Vector<TypedExpression> vector) {
        Class[] types = new Class[vector.size()];
        for (int i = 0; i < types.length; ++i) {
            TypedExpression expr = vector.elementAt(i);
            if (!expr.isTyped()) {
                return null;
            }
            types[i] = expr.getType();
        }
        return types;
    }

    public static Class<?> increaseArrayLevel(Class<?> clazz, Token errToken) throws ParseException {
        try {
            return Array.newInstance(clazz, 0).getClass();
        }
        catch (Exception e) {
            throw JavaHelper.makeParseException("Could not create class.", errToken);
        }
    }

    public static String makeTypeErrorString(Class<?> type) {
        if (type == null) {
            return "a null expression";
        }
        if (type == Types.UNTYPED) {
            return "an untyped expression";
        }
        return "an expression of type " + Types.typeToString(type);
    }

    private static TypedExpression makeTypedEquality(TypedExpression left, TypedExpression right) {
        Class<?> leftType = left.getType();
        Class<?> rightType = right.getType();
        Object castedRight = rightType == null ? right.getExpression() : (rightType.isPrimitive() ? new InvertibleExpression(leftType, right.getExpression(), (Function)new CastFunction(leftType), (Function)new CastFunction(rightType)) : JavaHelper.makeGuardedExpression(right));
        return new TypedExpression(left.getType(), (Expression)new EqualsExpression(left.getType(), left.getExpression(), castedRight));
    }

    public static TypedExpression makeEqualityAssertion(TypedExpression left, TypedExpression right, Token errToken) throws ParseException {
        Class<?> leftType = left.getType();
        Class<?> rightType = right.getType();
        if (leftType == Void.TYPE || rightType == Void.TYPE) {
            throw JavaHelper.makeParseException(VOID_TYPE_ERROR, errToken);
        }
        if (!left.isTyped() || !right.isTyped() || Types.allowsIdentityConversion(leftType, rightType)) {
            return new TypedExpression(leftType, (Expression)new EqualsExpression(leftType, JavaHelper.makeGuardedExpression(left), JavaHelper.makeGuardedExpression(right)));
        }
        if (Types.allowsLosslessWidening(rightType, leftType)) {
            return JavaHelper.makeTypedEquality(left, right);
        }
        if (Types.allowsLosslessWidening(leftType, rightType)) {
            return JavaHelper.makeTypedEquality(right, left);
        }
        throw JavaHelper.makeParseException("Type mismatch in assignment.", errToken);
    }

    public static TypedExpression makeSinglePartExpression(PrimaryPart firstPart, TypedExpression right, ParsedDeclarationNode declNode) throws ParseException {
        return JavaHelper.makeSinglePartExpression(firstPart, right, declNode, false);
    }

    public static TypedExpression makeSinglePartExpression(PrimaryPart firstPart, TypedExpression right, ParsedDeclarationNode declNode, boolean refactoring) throws ParseException {
        return switch (firstPart.type) {
            case 3 -> JavaHelper.handleExpressionCase(firstPart, right);
            case 0 -> JavaHelper.handleNameCase(firstPart, right, declNode, refactoring);
            default -> throw new RuntimeException(MALFORMED_PRIMARY_VECTOR);
        };
    }

    private static TypedExpression handleExpressionCase(PrimaryPart firstPart, TypedExpression right) throws ParseException {
        if (right == null) {
            return (TypedExpression)firstPart.obj;
        }
        throw JavaHelper.makeParseException(INVALID_LEFT_HAND_SIDE, firstPart.token);
    }

    private static TypedExpression handleNameCase(PrimaryPart firstPart, TypedExpression right, ParsedDeclarationNode declNode, boolean refactoring) throws ParseException {
        Object meaning = JavaHelper.getMeaningOfVariable(firstPart, declNode);
        if (meaning instanceof LocalVariable) {
            return JavaHelper.handleLocalVariableCase((LocalVariable)meaning, right, declNode, firstPart, refactoring);
        }
        if (meaning instanceof Class) {
            throw JavaHelper.makeParseException(NO_SUCH_VARIABLE + String.valueOf(firstPart.obj) + " (denotes a class).", firstPart.token);
        }
        return JavaHelper.handleUnknownVariableCase(firstPart, right, declNode);
    }

    private static Object getMeaningOfVariable(PrimaryPart firstPart, ParsedDeclarationNode declNode) throws ParseException {
        try {
            return declNode.interpreteName((String)firstPart.obj);
        }
        catch (LinkageError e) {
            String errorMessage = NO_SUCH_VARIABLE + String.valueOf(firstPart.obj) + "\n(denotes class with linkage problem:\n" + String.valueOf(e) + ").";
            _logger.warn((Object)errorMessage);
            _logger.debug((Object)(ENCOUNTERED + String.valueOf(e)), (Throwable)e);
            throw JavaHelper.makeParseException(errorMessage, firstPart.token);
        }
    }

    private static TypedExpression handleLocalVariableCase(LocalVariable variable, TypedExpression right, ParsedDeclarationNode declNode, PrimaryPart firstPart, boolean refactoring) throws ParseException {
        Class<?> type = declNode.findType(variable);
        if (refactoring) {
            JavaHelper.addTokenInformation(variable, firstPart.token.next);
        }
        if (right == null) {
            return new TypedExpression(type, (Expression)new VariableExpression(type, variable));
        }
        return JavaHelper.handleAssignment(type, variable, right, firstPart);
    }

    private static TypedExpression handleAssignment(Class<?> type, LocalVariable variable, TypedExpression right, PrimaryPart firstPart) throws ParseException {
        if (type == Types.UNTYPED) {
            return new TypedExpression(type, (Expression)new EqualsExpression(type, (Expression)new VariableExpression(type, variable), (Expression)new CallExpression(right.getType(), right.getExpression(), Identity.FUN)));
        }
        if (right.isTyped() && Types.allowsWideningConversion(right.getType(), type)) {
            return new TypedExpression(type, (Expression)new EqualsExpression(type, (Expression)new VariableExpression(type, variable), (Expression)new CallExpression(right.getType(), right.getExpression(), (Function)new CastFunction(type))));
        }
        throw JavaHelper.makeParseException("Cannot assign " + JavaHelper.makeTypeErrorString(right.getType()) + TO + JavaHelper.makeTypeErrorString(type) + PERIOD, firstPart.token);
    }

    private static TypedExpression handleUnknownVariableCase(PrimaryPart firstPart, TypedExpression right, ParsedDeclarationNode declNode) throws ParseException {
        _logger.debug((Object)("No variable " + String.valueOf(firstPart.obj) + DECLARED_IN + String.valueOf(declNode)));
        Collection<VariableSuggestion> variableSuggestions = VariableSuggestion.suggest(firstPart, right, declNode);
        throw JavaHelper.makeExtendedParseException(NO_SUCH_VARIABLE + String.valueOf(firstPart.obj), variableSuggestions, firstPart.token);
    }

    public static TypedExpression makeConstructorExpression(Class<?> clazz, Vector<TypedExpression> vector, Token errToken) throws ParseException {
        Class<?>[] types = JavaHelper.makeTypeArray(vector);
        if (types != null) {
            Constructor<?> constructor;
            try {
                constructor = Executor.findBestConstructor(clazz, types, true);
                if (constructor == null) {
                    throw JavaHelper.makeParseException("Multiple constructors match: " + Executor.renderMethodSignature(clazz, INIT, types), errToken);
                }
            }
            catch (NoSuchMethodException e) {
                Collection<ConstructorSuggestion> suggestions = ConstructorSuggestion.suggest(clazz);
                throw JavaHelper.makeExtendedParseException("No such constructor: " + Executor.renderMethodSignature(clazz, INIT, types), suggestions, errToken);
            }
            catch (LinkageError e) {
                _logger.warn((Object)(ENCOUNTERED + String.valueOf(e)), (Throwable)e);
                throw JavaHelper.makeParseException("Cannot not bind constructor " + Executor.renderMethodSignature(clazz, INIT, types) + DUE_TO + String.valueOf(e) + COLON, errToken);
            }
            return new TypedExpression(clazz, (Expression)new CallExpression(clazz, (Expression)JavaHelper.makeTupleExpression(vector), (Function)new ConstructorFunction(constructor)));
        }
        return new TypedExpression(clazz, (Expression)new CallExpression(clazz, (Expression)JavaHelper.makeTupleExpression(vector), (Function)new DynamicConstructorFunction(clazz)));
    }

    public static TypedExpression makeMethodCall(TypedExpression expr, Class<?> superClass, String name, Vector<TypedExpression> args, Token errorToken) throws ParseException {
        Method method;
        if (superClass != null) {
            throw JavaHelper.makeParseException("Calls to super object are not supported.", errorToken);
        }
        Class<?> targetType = expr.getType();
        if (targetType == null) {
            throw JavaHelper.makeParseException("Cannot invoke method on null object.", errorToken);
        }
        Class<?>[] types = JavaHelper.makeTypeArray(args);
        if (types == null || !expr.isTyped()) {
            return new TypedExpression(Types.UNTYPED, (Expression)new CallExpression(Types.UNTYPED, (Expression)new TupleExpression(expr.getExpression(), (Expression)JavaHelper.makeTupleExpression(args)), (Function)new DynamicMethodFunction(name)));
        }
        try {
            method = Executor.findBestMethod(targetType, name, types, true);
            if (method == null) {
                throw JavaHelper.makeParseException(MULTIPLE_METHODS_MATCH + Executor.renderMethodSignature(targetType, name, types), errorToken);
            }
        }
        catch (NoSuchMethodException e) {
            List<MethodSuggestion> methodSuggestions = MethodSuggestion.suggest(targetType, name, types, Integer.MAX_VALUE);
            throw JavaHelper.makeExtendedParseException("No such method: " + Executor.renderMethodSignature(targetType, name, types) + JavaHelper.checkForGivenPrefix(name) + KNOWN_METHODS, methodSuggestions, errorToken);
        }
        catch (LinkageError e) {
            _logger.warn((Object)(ENCOUNTERED + String.valueOf(e)), (Throwable)e);
            throw JavaHelper.makeParseException(CANNOT_NOT_BIND_METHOD + Executor.renderMethodSignature(targetType, name, types) + DUE_TO + String.valueOf(e) + COLON, errorToken);
        }
        return new TypedExpression(method.getReturnType(), (Expression)new CallExpression(method.getReturnType(), (Expression)new TupleExpression(expr.getExpression(), (Expression)JavaHelper.makeTupleExpression(args)), (Function)new MethodFunction(method)));
    }

    public static TypedExpression makeExpression(Vector<PrimaryPart> vector, TypedExpression right, ParsedDeclarationNode declNode, Token rightErrToken) throws ParseException {
        return JavaHelper.makeExpression(vector, right, declNode, rightErrToken, false);
    }

    public static TypedExpression makeExpression(Vector<PrimaryPart> vector, TypedExpression right, ParsedDeclarationNode declNode, Token rightErrToken, boolean refactoring) throws ParseException {
        int i;
        Object name;
        if (right != null) {
            JavaHelper.ensureNonVoid(right, rightErrToken);
        }
        PrimaryPart firstPart = vector.elementAt(0);
        if (vector.size() == 1) {
            return JavaHelper.makeSinglePartExpression(firstPart, right, declNode, refactoring);
        }
        int m = vector.size();
        if (right != null) {
            --m;
        }
        Object composed = null;
        switch (firstPart.type) {
            case 3: {
                composed = firstPart.obj;
                name = firstPart.toString();
                break;
            }
            case 0: {
                name = (String)firstPart.obj;
                if (declNode == null) break;
                try {
                    composed = declNode.interpreteName((String)name);
                }
                catch (LinkageError e) {
                    _logger.warn((Object)(ENCOUNTERED + String.valueOf(e)), (Throwable)e);
                    throw JavaHelper.makeParseException(LOADING_CLASS + (String)name + DUE_TO + String.valueOf(e), firstPart.token);
                }
                int lasti = i;
                for (i = 1; i < m; ++i) {
                    PrimaryPart part = vector.elementAt(i);
                    if (part.type != 0) break;
                    name = (String)name + PERIOD + String.valueOf(part.obj);
                    try {
                        Object newComposed = declNode.interpreteName((String)name);
                        continue;
                    }
                    catch (LinkageError e) {
                        _logger.warn((Object)(ENCOUNTERED + String.valueOf(e)), (Throwable)e);
                        throw JavaHelper.makeParseException(LOADING_CLASS + (String)name + " due to linkage problem:\n" + String.valueOf(e), firstPart.token);
                    }
                }
                i = lasti;
                break;
            }
            default: {
                throw new RuntimeException(MALFORMED_PRIMARY_VECTOR);
            }
        }
        if (composed == null) {
            _logger.debug((Object)("No class or variable " + (String)name + DECLARED_IN + String.valueOf(declNode)));
            throw JavaHelper.makeParseException(NO_SUCH_CLASS_OR_VARIABLE + (String)name, firstPart.token);
        }
        if (composed instanceof LocalVariable) {
            if (refactoring) {
                JavaHelper.addTokenInformation((LocalVariable)composed, firstPart.token.next);
            }
            Class<?> type = declNode.findType((LocalVariable)composed);
            composed = new TypedExpression(type, (Expression)new VariableExpression(type, (LocalVariable)composed));
        }
        while (i < m) {
            PrimaryPart part = vector.elementAt(i);
            ++i;
            switch (part.type) {
                case 0: {
                    Vector args = null;
                    if (i < vector.size()) {
                        PrimaryPart additionalPart = vector.elementAt(i);
                        if (additionalPart.type == 2) {
                            Vector vec;
                            ++i;
                            args = vec = (Vector)additionalPart.obj;
                        }
                    }
                    if (args != null) {
                        if (composed instanceof Class) {
                            Method method;
                            Class<?>[] types = JavaHelper.makeTypeArray(args);
                            if (types == null) {
                                composed = new TypedExpression(Types.UNTYPED, (Expression)new CallExpression(Types.UNTYPED, (Expression)JavaHelper.makeTupleExpression(args), (Function)new DynamicStaticMethodFunction((String)part.obj, (Class)composed)));
                                break;
                            }
                            try {
                                method = Executor.findBestMethod((Class)composed, (String)part.obj, types, true);
                                if (method == null) {
                                    throw JavaHelper.makeParseException(MULTIPLE_METHODS_MATCH + Executor.renderMethodSignature((Class)composed, (String)part.obj, types), part.token);
                                }
                            }
                            catch (NoSuchMethodException e) {
                                List<MethodSuggestion> methodSuggestions = MethodSuggestion.suggest((Class)composed, (String)part.obj, types, 8);
                                throw JavaHelper.makeExtendedParseException("No such static method: " + Executor.renderMethodSignature((Class)composed, (String)part.obj, types) + JavaHelper.checkForGivenPrefix((String)part.obj) + KNOWN_METHODS, methodSuggestions, part.token);
                            }
                            catch (LinkageError e) {
                                _logger.warn((Object)(ENCOUNTERED + String.valueOf(e)), (Throwable)e);
                                throw JavaHelper.makeParseException(CANNOT_NOT_BIND_METHOD + Executor.renderMethodSignature((Class)composed, (String)part.obj, types) + DUE_TO + String.valueOf(e) + COLON, part.token);
                            }
                            if ((method.getModifiers() & 8) == 0) {
                                throw JavaHelper.makeParseException("Cannot make static call to instance method.", part.token);
                            }
                            composed = new TypedExpression(method.getReturnType(), (Expression)new CallExpression(method.getReturnType(), (Expression)JavaHelper.makeTupleExpression(args), (Function)new StaticMethodFunction(method)));
                            break;
                        }
                        composed = JavaHelper.makeMethodCall((TypedExpression)composed, null, (String)part.obj, args, part.token);
                        break;
                    }
                    if (composed instanceof Class) {
                        Field field;
                        Class clazz = (Class)composed;
                        try {
                            field = clazz.getField((String)part.obj);
                        }
                        catch (Exception e) {
                            List<FieldSuggestion> fieldSuggestions = FieldSuggestion.suggest((Class)composed, (String)part.obj, 8);
                            throw JavaHelper.makeExtendedParseException(NO_SUCH_STATIC_FIELD + String.valueOf(part.obj) + KNOWN_FIELDS, fieldSuggestions, part.token);
                        }
                        composed = new TypedExpression(field.getType(), (Expression)new NoArgExpression(field.getType(), (NoArgFunction)new StaticFieldFunction(field)));
                        break;
                    }
                    if (((TypedExpression)composed).isTyped()) {
                        Field field;
                        Class<?> type = ((TypedExpression)composed).getType();
                        if (type == null) {
                            throw JavaHelper.makeParseException("Cannot access field of null object.", part.token);
                        }
                        if (type.isArray() && "length".equals(part.obj)) {
                            composed = new TypedExpression(Integer.TYPE, (Expression)new CallExpression(Integer.TYPE, ((TypedExpression)composed).getExpression(), (Function)new DynamicFieldFunction((String)part.obj)));
                            break;
                        }
                        try {
                            field = type.getField((String)part.obj);
                        }
                        catch (Exception e) {
                            List<FieldSuggestion> fieldSuggestions = FieldSuggestion.suggest(type, (String)part.obj, Integer.MAX_VALUE);
                            throw JavaHelper.makeExtendedParseException(NO_SUCH_STATIC_FIELD + String.valueOf(part.obj) + KNOWN_FIELDS, fieldSuggestions, part.token);
                        }
                        composed = new TypedExpression(field.getType(), (Expression)new CallExpression(field.getType(), ((TypedExpression)composed).getExpression(), (Function)new FieldFunction(field)));
                        break;
                    }
                    composed = new TypedExpression(Types.UNTYPED, (Expression)new CallExpression(Types.UNTYPED, ((TypedExpression)composed).getExpression(), (Function)new DynamicFieldFunction((String)part.obj)));
                    break;
                }
                case 1: {
                    if (!(composed instanceof TypedExpression)) {
                        throw JavaHelper.makeParseException(NO_SUCH_CLASS_OR_VARIABLE, part.token);
                    }
                    Class<?> type = Types.UNTYPED;
                    if (((TypedExpression)composed).isTyped()) {
                        type = ((TypedExpression)composed).getType();
                        if (!type.isArray()) {
                            throw JavaHelper.makeParseException(NOT_AN_ARRAY, part.token);
                        }
                        type = type.getComponentType();
                    }
                    JavaHelper.ensureConvertability(Integer.TYPE, (TypedExpression)part.obj, part.token);
                    composed = new TypedExpression(type, (Expression)new CallExpression(type, (Expression)new TupleExpression(((TypedExpression)composed).getExpression(), ((TypedExpression)part.obj).getExpression()), ArrayFunction.FUN));
                    break;
                }
                case 2: {
                    throw JavaHelper.makeParseException("Bad method call or no such method.", part.token);
                }
                default: {
                    throw new RuntimeException(MALFORMED_PRIMARY_VECTOR);
                }
            }
        }
        if (right != null) {
            if (i == vector.size()) {
                throw JavaHelper.makeParseException(INVALID_LEFT_HAND_SIDE, rightErrToken);
            }
            PrimaryPart part = vector.elementAt(i);
            switch (part.type) {
                case 0: {
                    Field field;
                    Class<?> type;
                    if (composed instanceof TypedExpression) {
                        if (((TypedExpression)composed).isTyped()) {
                            type = ((TypedExpression)composed).getType();
                            try {
                                field = type.getField((String)part.obj);
                            }
                            catch (Exception e) {
                                throw JavaHelper.makeParseException(NO_SUCH_FIELD, part.token);
                            }
                            JavaHelper.ensureConvertability(field.getType(), right, rightErrToken);
                            composed = new TypedExpression(field.getType(), (Expression)new CallExpression(field.getType(), (Expression)new TupleExpression(((TypedExpression)composed).getExpression(), right.getExpression()), (Function)new FieldWriteFunction(field)));
                            break;
                        }
                        composed = new TypedExpression(Types.UNTYPED, (Expression)new CallExpression(Types.UNTYPED, (Expression)new TupleExpression(((TypedExpression)composed).getExpression(), right.getExpression()), (Function)new DynamicFieldWriteFunction((String)part.obj)));
                        break;
                    }
                    Class clazz = (Class)composed;
                    try {
                        field = clazz.getField((String)part.obj);
                    }
                    catch (Exception e) {
                        throw JavaHelper.makeParseException(NO_SUCH_FIELD, part.token);
                    }
                    JavaHelper.ensureConvertability(field.getType(), right, rightErrToken);
                    composed = new TypedExpression(field.getType(), (Expression)new CallExpression(field.getType(), right.getExpression(), (Function)new StaticFieldWriteFunction(field)));
                    break;
                }
                case 1: {
                    if (!(composed instanceof TypedExpression)) {
                        throw JavaHelper.makeParseException(NO_SUCH_CLASS_OR_VARIABLE, part.token);
                    }
                    Class<?> type = Types.UNTYPED;
                    if (((TypedExpression)composed).isTyped()) {
                        type = ((TypedExpression)composed).getType();
                        if (!type.isArray()) {
                            throw JavaHelper.makeParseException(NOT_AN_ARRAY, part.token);
                        }
                        type = type.getComponentType();
                        JavaHelper.ensureConvertability(type, right, rightErrToken);
                    }
                    JavaHelper.ensureConvertability(Integer.TYPE, (TypedExpression)part.obj, part.token);
                    composed = new TypedExpression(type, (Expression)new CallExpression(type, (Expression)new TupleExpression(((TypedExpression)composed).getExpression(), ((TypedExpression)part.obj).getExpression(), right.getExpression()), ArrayWriteFunction.FUN));
                    break;
                }
                default: {
                    throw new RuntimeException(MALFORMED_PRIMARY_VECTOR);
                }
            }
        }
        if (!(composed instanceof TypedExpression)) {
            throw JavaHelper.makeParseException(NO_SUCH_CLASS_OR_VARIABLE, firstPart.token);
        }
        return (TypedExpression)composed;
    }

    private static String checkForGivenPrefix(String obj) {
        Object name = obj;
        if (((String)name).endsWith("_") && !((String)(name = ((String)name).substring(0, ((String)name).length() - 1))).isEmpty()) {
            name = " \n (prefixing \"" + (String)name + "\")";
        }
        return name;
    }

    private static void addTokenInformation(LocalVariable var, Token t) {
        var.variableBeginLine = t.beginLine;
        var.variableBeginColumn = t.beginColumn;
        var.variableEndLine = t.endLine;
        var.variableEndColumn = t.endColumn;
    }
}

