/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.java;

import de.renew.formalism.java.JavaHelper;
import de.renew.formalism.java.Suggestion;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class FieldSuggestion
extends Suggestion {
    public static final Logger LOGGER = Logger.getLogger(FieldSuggestion.class);
    private final String _attemptedName;
    private Field _field;

    public static List<FieldSuggestion> suggest(Class<?> clazz, String name, int modifier) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(JavaHelper.class.getName() + ": Class = " + clazz.toString()));
        }
        ArrayList<Field> resultFieldList = new ArrayList<Field>();
        Field[] fields = clazz.getFields();
        if (fields.length != 0) {
            String fieldPattern = name;
            boolean filter = false;
            if (fieldPattern.endsWith("_")) {
                fieldPattern = fieldPattern.substring(0, fieldPattern.length() - 1);
                filter = true;
            }
            if (fields.length > 20) {
                filter = true;
            }
            if (name.equals("_")) {
                filter = false;
            }
            for (Field field : fields) {
                int mod = field.getModifiers();
                String fieldName = field.getName();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Name " + fieldName + " pattern: " + fieldPattern));
                    LOGGER.debug((Object)(JavaHelper.class.getName() + ": modifier for " + field.getName() + "= " + mod + " " + !filter + fieldName.startsWith(fieldPattern)));
                }
                if (filter && !fieldName.startsWith(fieldPattern)) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)(JavaHelper.class.getName() + ": passed filter " + ((modifier & mod) != 0)));
                }
                if ((modifier & mod) == 0) continue;
                resultFieldList.add(field);
            }
        }
        ArrayList<FieldSuggestion> result = new ArrayList<FieldSuggestion>();
        for (Field field : resultFieldList) {
            result.add(new FieldSuggestion(field, name));
        }
        Collections.sort(result);
        return result;
    }

    public FieldSuggestion(Field field, String attemptedName) {
        super(field.getName(), field.getType().getSimpleName());
        this._field = field;
        this._attemptedName = attemptedName;
    }

    public String getDeclaringClassName() {
        return this._field.getDeclaringClass().getSimpleName();
    }

    public Field getField() {
        return this._field;
    }

    public String getAttemptedName() {
        return this._attemptedName;
    }

    @Override
    public String toString() {
        return "<html>" + this.getName() + " : " + this.getTypeName() + " <font color=gray>- " + this.getDeclaringClassName() + "</font></html>";
    }
}

