/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.function;

import de.renew.expression.Function;
import de.renew.formalism.function.Executor;
import de.renew.unify.Impossible;
import de.renew.unify.Tuple;
import de.renew.util.ReflectionSerializer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;

public class DynamicStaticMethodFunction
implements Function {
    private final String _method;
    transient Class<?> _clazz;

    public DynamicStaticMethodFunction(String method, Class<?> clazz) {
        this._method = method;
        this._clazz = clazz;
    }

    public Object function(Object param) throws Impossible {
        Tuple args = (Tuple)param;
        Object[] paramArr = new Object[args.getArity()];
        for (int i = 0; i < paramArr.length; ++i) {
            paramArr[i] = args.getComponent(i);
        }
        try {
            return Executor.executeMethod(this._clazz, null, this._method, paramArr);
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException) {
                throw new Impossible("InvocationTargetException occured during method call: " + String.valueOf(((InvocationTargetException)e).getTargetException()));
            }
            throw new Impossible("Exception occured during method call: " + String.valueOf(e));
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        ReflectionSerializer.writeClass((ObjectOutputStream)out, this._clazz);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._clazz = ReflectionSerializer.readClass((ObjectInputStream)in);
    }
}

