/*
 * Decompiled with CFR 0.152.
 */
package de.renew.tablet.tools;

import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.CreationTool;
import de.renew.gui.ArcConnection;
import de.renew.gui.CPNDrawingHelper;
import de.renew.gui.PlaceFigure;
import de.renew.gui.TransitionFigure;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class PTToggleCreationTool
extends CreationTool {
    private boolean _toggle = true;
    private Figure _lastCreated;
    private Figure _target = null;

    public PTToggleCreationTool(DrawingEditor editor) {
        super(editor);
    }

    public void mouseDrag(MouseEvent e, int x, int y) {
        if (this._target == null) {
            super.mouseDrag(e, x, y);
        }
    }

    public void deactivate() {
        this._lastCreated = null;
        super.deactivate();
    }

    public void mouseDown(MouseEvent e, int x, int y) {
        this._target = this.findConnectionTarget(new ArcConnection(), this._lastCreated, x, y, this.view().drawing());
        if (this._target == null) {
            super.mouseDown(e, x, y);
        }
    }

    protected Figure createFigure() {
        if (this._toggle) {
            this._toggle = !this._toggle;
            return new PlaceFigure();
        }
        this._toggle = !this._toggle;
        return new TransitionFigure();
    }

    public void mouseUp(MouseEvent e, int x, int y) {
        Figure created = null;
        if (this._target != null) {
            created = this._target;
            this._target = null;
            this._toggle = !this._toggle;
        } else {
            created = this.createdFigure();
            if (created.displayBox().width < 10 || created.displayBox().height < 10) {
                Point loc = created.displayBox().getLocation();
                Dimension d = this._toggle ? TransitionFigure.defaultDimension() : PlaceFigure.defaultDimension();
                int w2 = d.width / 2;
                int h2 = d.height / 2;
                created.displayBox(new Point(loc.x - w2, loc.y - h2), new Point(loc.x - w2 + d.width, loc.y - h2 + d.height));
            }
        }
        if (this._lastCreated != null) {
            ArcConnection arc = new CPNDrawingHelper().createArcConnection((AttributeFigure)this._lastCreated, (AttributeFigure)created, 1);
            this.view().add((Figure)arc);
            this.view().checkDamage();
        }
        this._lastCreated = created;
    }

    public void activate() {
        this._toggle = true;
        this._target = null;
        super.activate();
    }

    protected Figure findConnectionTarget(ArcConnection arc, Figure owner, int x, int y, Drawing drawing) {
        Figure target = this.findConnectableFigure(arc, x, y, drawing);
        if (owner == null) {
            if (target instanceof TransitionFigure) {
                this._toggle = !this._toggle;
            }
            return target;
        }
        if (target != null && target.canConnect() && !target.includes(owner) && arc.canConnect(owner, target)) {
            return target;
        }
        return null;
    }

    protected Figure findConnectableFigure(ArcConnection arc, int x, int y, Drawing drawing) {
        FigureEnumeration k = drawing.figuresReverse();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            if (figure.includes((Figure)arc) || !figure.canConnect() || !figure.containsPoint(x, y)) continue;
            return figure;
        }
        return null;
    }
}

