<!-- Adapted from: https://www.writethedocs.org/guide/writing/beginners-guide-to-docs/ -->

# NavigatorVC

## User Guide
 
_NavigatorVC_ extends the Navigator with Version Control System functionality.

* [Dependencies](#dependencies)
* [Required by](#required-by)

### Features

- Enables _NavigatorGit_ to provide the functionality of version control wit Git
- Get the Log  from a file via _NavigatorGit_
- Get the Info from a file via _NavigatorGit_

### Example Usage

1. Open the Navigator via File -> Navigator
2. Right-click on a File.
3. Select Git and one of the three options.
4. View the feedback in the console.
5. Note that this only works with files in a git repository.

### Provided Commands

<!-- Use the classes implementing CLCommand. The 'help' output of the command can be a useful description -->

_NavigatorVC_ does not provide any Commands

### Installation

Install _NavigatorVC_ by putting the JAR file inside the `dist/plugins` directory.

It will be automatically loaded at startup of Renew - see below for more configuration options.

### Dependencies

This plugin depends on the following plugins and external libraries:

<!-- must match the `module-info.java` -->

- `Navigator`: Provides the Gui
- `CH`: Is used to create the Gui
- `log4j`: Logging Framework

## Required by

The NavigatorVC plugin is required by

- Navigator Git Extension `de.renew.navigator.vc.git`
- Navigator SVN Extension `de.renew.navigator.vc.svn`

### Configuration

During the initialization of _NavigatorVC_, the following properties are read from the `renew.properties` file in the Renew root directory.

**NAME**|**TYPE**|**DESCRIPTION**|**DEFAULT**
:-----|:-----:|:-----|:-----
`de.renew.navigator.diff.color`|`boolean`|Color|true
## Developer Guide

### Core Classes

- `NavigatorVCPlugin`: Implements the `IPlugin` interface to manage the startup and shutdown.
- `VersionControlAggregatorImpl`: Contains most functionality of the Plugin.

## How to Extend

The easiest parts to extend are actions. They provide an easy method to add
a menu button with an action to perform. You can also add new file filters and
GUI extensions by writing a custom plugin and using the **NavigatorExtension**
interface.


### Included Packages
- `de.renew.navigator.vc`


### Public Interfaces
- `de.renew.navigator.vc.Repository`
- `de.renew.navigator.vc.VersionControl`
- `de.renew.navigator.vc.VersionControlAggregator` - the VersionControlAggregator holds a list of different version controls while behaving as a version control itself

### Additional Information

<!-- License -->
