/*
 * Decompiled with CFR 0.152.
 */
package de.renew.lola2.analysis;

import de.renew.lola2.analysis.DirectLolaResult;
import de.renew.lola2.analysis.IndirectLolaResult;
import de.renew.lola2.analysis.LolaAnalyzer;
import de.renew.lola2.analysis.LolaResultStatus;
import de.renew.lola2.parser.LolaParser;
import de.renew.lola2.parser.NetFileParseError;
import de.renew.lola2.parser.Place;
import de.renew.lola2.parser.Transition;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class PropertyAnalyzer
extends LolaAnalyzer {
    private static Logger _logger = Logger.getLogger(PropertyAnalyzer.class);

    public PropertyAnalyzer(String lolaPath) {
        super(lolaPath);
    }

    public PropertyAnalyzer() {
    }

    public DirectLolaResult checkTransitionQuasiLiveness(String transitionName, File netFile) {
        String formula = "EF FIREABLE(" + transitionName + ")";
        _logger.debug((Object)("[LolaAnalyzer] Checking quasi-liveness for transition named " + transitionName));
        DirectLolaResult lolaOutput = this.callLola(formula, netFile);
        return lolaOutput;
    }

    public DirectLolaResult checkTransitionLiveness(String transitionName, File netFile) {
        _logger.debug((Object)("[LolaAnalyzer] Checking liveness for transition named " + transitionName));
        String formula = "AG EF FIREABLE(" + transitionName + ")";
        DirectLolaResult lolaOutput = this.callLola(formula, netFile);
        return lolaOutput;
    }

    public DirectLolaResult checkPlaceBoundedness(String placeName, File netFile) {
        String formula = "AG " + placeName + " < oo";
        _logger.debug((Object)("[LolaAnalyzer] Checking boundedness for place named " + placeName));
        DirectLolaResult lolaOutput = this.callLola(formula, netFile, new String[]{"--search=cover", "--encoder=full"});
        return lolaOutput;
    }

    public IndirectLolaResult checkNetBoundedness(File netFile) {
        LolaParser lolaParser;
        try (FileInputStream stream = new FileInputStream(netFile);){
            lolaParser = new LolaParser();
            lolaParser.parse(stream);
        }
        catch (NetFileParseError | IOException e) {
            _logger.error((Object)("[LolaAnalyzer] Could not parse netFile " + netFile.getAbsolutePath()));
            return new IndirectLolaResult(LolaResultStatus.ERROR);
        }
        LolaResultStatus status = LolaResultStatus.YES;
        for (Place place : lolaParser.getPlaces()) {
            String placeName = place.getName();
            DirectLolaResult pResult = this.checkPlaceBoundedness(placeName, netFile);
            LolaResultStatus pStatus = pResult.getStatus();
            if (pStatus == LolaResultStatus.YES) continue;
            if (pStatus == LolaResultStatus.NO) {
                status = pStatus;
                _logger.info((Object)("[Lola Checklist] Found unbounded place " + placeName + ". Net is not bounded. "));
                break;
            }
            status = pStatus;
            _logger.info((Object)("[Lola Checklist] Could not check boundedness for " + placeName + ". Status: " + String.valueOf((Object)pStatus)));
            break;
        }
        return new IndirectLolaResult(status);
    }

    public IndirectLolaResult checkNetLiveness(File netFile, boolean checkQuasiLivenessFirst) {
        LolaResultStatus tStatus;
        DirectLolaResult tResult;
        String transitionName;
        LolaParser lolaParser;
        try (FileInputStream stream = new FileInputStream(netFile);){
            lolaParser = new LolaParser();
            lolaParser.parse(stream);
        }
        catch (NetFileParseError | IOException e) {
            _logger.error((Object)("[LolaAnalyzer] Could not parse netFile " + netFile.getAbsolutePath()));
            return new IndirectLolaResult(LolaResultStatus.ERROR);
        }
        LolaResultStatus status = LolaResultStatus.YES;
        if (checkQuasiLivenessFirst) {
            for (Transition transition : lolaParser.getTransitions()) {
                transitionName = transition.getName();
                tResult = this.checkTransitionQuasiLiveness(transitionName, netFile);
                tStatus = tResult.getStatus();
                if (tStatus == LolaResultStatus.YES) continue;
                if (tStatus == LolaResultStatus.NO) {
                    status = tStatus;
                    _logger.info((Object)("[Lola Checklist] Found dead transition " + transitionName + ". Net is not live. "));
                    break;
                }
                status = tStatus;
                _logger.info((Object)("[Lola Checklist] Could not check quasi-liveness for " + transitionName + ". Status: " + String.valueOf((Object)tStatus)));
                break;
            }
        }
        if (status == LolaResultStatus.YES) {
            for (Transition transition : lolaParser.getTransitions()) {
                transitionName = transition.getName();
                tResult = this.checkTransitionLiveness(transitionName, netFile);
                tStatus = tResult.getStatus();
                if (tStatus == LolaResultStatus.YES) continue;
                if (tStatus == LolaResultStatus.NO) {
                    status = tStatus;
                    _logger.info((Object)("[Lola Checklist] Found not-live transition " + transitionName + ". Net is not live. "));
                    break;
                }
                status = tStatus;
                _logger.info((Object)("[Lola Checklist] Could not check liveness for " + transitionName + ". Status: " + String.valueOf((Object)tStatus)));
                break;
            }
        }
        return new IndirectLolaResult(status);
    }

    public IndirectLolaResult checkNetQuasiLiveness(File netFile) {
        LolaParser lolaParser;
        try (FileInputStream stream = new FileInputStream(netFile);){
            lolaParser = new LolaParser();
            lolaParser.parse(stream);
        }
        catch (NetFileParseError | IOException e) {
            _logger.error((Object)("[LolaAnalyzer] Could not parse netFile " + netFile.getAbsolutePath()));
            return new IndirectLolaResult(LolaResultStatus.ERROR);
        }
        LolaResultStatus status = LolaResultStatus.YES;
        for (Transition transition : lolaParser.getTransitions()) {
            String transitionName = transition.getName();
            DirectLolaResult tResult = this.checkTransitionQuasiLiveness(transitionName, netFile);
            LolaResultStatus tStatus = tResult.getStatus();
            if (tStatus == LolaResultStatus.YES) continue;
            if (tStatus == LolaResultStatus.NO) {
                status = tStatus;
                _logger.info((Object)("[Lola Checklist] Found dead transition " + transitionName + ". Net is not quasi-live. "));
                break;
            }
            status = tStatus;
            _logger.info((Object)("[Lola Checklist] Could not check quasi-liveness for " + transitionName + ". Status: " + String.valueOf((Object)tStatus)));
            break;
        }
        return new IndirectLolaResult(status);
    }

    public DirectLolaResult checkNetDeadlockFreedom(File netFile) {
        String formula = "NOT EF DEADLOCK";
        _logger.debug((Object)"[LolaAnalyzer] Checking deadlock freedom");
        DirectLolaResult lolaOutput = this.callLola(formula, netFile);
        return lolaOutput;
    }

    public DirectLolaResult checkMarkingReachability(String marking, File netFile) {
        String formula = "EF " + marking;
        _logger.debug((Object)("[LolaAnalyzer] Checking reachability of marking " + marking));
        DirectLolaResult lolaOutput = this.callLola(formula, netFile);
        return lolaOutput;
    }

    public DirectLolaResult checkMarkingHomeState(String marking, File netFile) {
        String formula = "AG EF " + marking;
        _logger.debug((Object)("[LolaAnalyzer] Checking wether " + marking + " is a home state"));
        DirectLolaResult lolaOutput = this.callLola(formula, netFile);
        return lolaOutput;
    }

    public DirectLolaResult checkNetReversibility(File netFile) {
        return this.checkMarkingHomeState("INITIAL", netFile);
    }
}

