/*
 * Decompiled with CFR 0.152.
 */
package de.renew.lola2.commands;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.util.Command;
import de.renew.gui.CPNDrawing;
import de.renew.lola2.LolaTask;
import de.renew.lola2.analysis.LolaAnalyzer;
import de.renew.lola2.commands.CheckVerificationRequestCommand;
import de.renew.plugin.command.CLCommand;
import java.io.PrintStream;
import org.apache.log4j.Logger;

public class CheckAllTasksCommand
extends Command
implements CLCommand {
    private String _lolaPath;
    private static Logger _logger = Logger.getLogger(CheckVerificationRequestCommand.class);

    public CheckAllTasksCommand(String name, String path) {
        super(name);
        this._lolaPath = path;
    }

    public void execute() {
        DrawApplication app = DrawPlugin.getGui();
        Drawing drawing = app.drawing();
        app.getUndoRedoManager().prepareUndoSnapshot(drawing);
        if (!(drawing instanceof CPNDrawing)) {
            _logger.error((Object)"[Lola] Drawing needs to be a CPNDrawing. Aborting.");
            return;
        }
        FigureEnumeration figures = drawing.figures();
        Boolean changed = false;
        while (figures.hasMoreElements()) {
            Figure fig = (Figure)figures.nextElement();
            if (fig instanceof TextFigure) {
                TextFigure textFig = (TextFigure)fig;
                String text = textFig.getText();
                if (!text.toLowerCase().startsWith("formula")) continue;
                LolaTask task = new LolaTask((TextFigure)fig, (CPNDrawing)drawing);
                task.check(new LolaAnalyzer(this._lolaPath));
                task.colorFigure();
                fig.changed();
                changed = true;
                continue;
            }
            _logger.info((Object)"[Lola] Currently only checking TextFigures.");
        }
        if (changed.booleanValue()) {
            DrawPlugin.getGui().view().checkDamage();
            app.getUndoRedoManager().commitUndoSnapshot(drawing);
        }
    }

    public void execute(String[] args, PrintStream response) {
    }

    public String getDescription() {
        return null;
    }
}

