/*
 * Decompiled with CFR 0.152.
 */
package de.renew.lola2.analysis;

import de.renew.lola2.analysis.LolaResult;
import de.renew.lola2.analysis.LolaResultStatus;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class DirectLolaResult
implements LolaResult {
    private static Logger _logger = Logger.getLogger(DirectLolaResult.class);
    private static final String ANALYSIS_RESULT_PATTERN_STRING = ".*\"analysis\".*\"result\":\\s*(true|false)";
    private static final Pattern ANALYSIS_RESULT_PATTERN = Pattern.compile(".*\"analysis\".*\"result\":\\s*(true|false)");
    private String _output;
    private String _error;
    private LolaResultStatus _status;

    public DirectLolaResult(int returnValue, String output, String error) {
        this._output = output;
        this._error = error;
        this._status = this.checkResultStatus(returnValue, output);
    }

    private LolaResultStatus checkResultStatus(int returnValue, String output) {
        LolaResultStatus status;
        if (returnValue == 0) {
            Matcher matcher = ANALYSIS_RESULT_PATTERN.matcher(output);
            if (matcher.find()) {
                boolean result = Boolean.parseBoolean(matcher.group(1));
                status = result ? LolaResultStatus.YES : LolaResultStatus.NO;
            } else {
                status = LolaResultStatus.ERROR;
                _logger.error((Object)"LoLA call returned an error.");
            }
        } else {
            status = LolaResultStatus.ERROR;
            _logger.error((Object)"LoLA call returned an error.");
        }
        return status;
    }

    public String getOutput() {
        return this._output;
    }

    public String getError() {
        return this._error;
    }

    @Override
    public LolaResultStatus getStatus() {
        return this._status;
    }
}

