/*
 * Decompiled with CFR 0.152.
 */
package de.renew.lola2;

import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.util.ColorMap;
import de.renew.gui.CPNDrawing;
import de.renew.lola2.LolaFileCreator;
import de.renew.lola2.analysis.DirectLolaResult;
import de.renew.lola2.analysis.LolaAnalyzer;
import de.renew.lola2.gui.LolaGUIHelper;
import java.awt.Color;
import java.io.File;
import org.apache.log4j.Logger;

public class LolaTask {
    private static Logger _logger = Logger.getLogger(LolaTask.class);
    private String _text;
    private String _formula;
    private DirectLolaResult _result;
    private final TextFigure _figure;
    private final CPNDrawing _drawing;

    public LolaTask(TextFigure fig, CPNDrawing drawing) {
        this._figure = fig;
        this._drawing = drawing;
        this._text = fig.getText();
        this._formula = this.parseText(this._text);
    }

    private String parseText(String text) {
        String formula = null;
        if (text.toLowerCase().startsWith("formula")) {
            formula = text.substring("formula".length()).trim();
        }
        return formula;
    }

    public DirectLolaResult check(LolaAnalyzer analyzer) {
        File lolaTmpFile = new LolaFileCreator().writeTemporaryLolaFile(this._drawing);
        this._result = analyzer.callLola(this._formula, lolaTmpFile);
        return this._result;
    }

    public void colorFigure() {
        if (this._result != null) {
            Color statusColor = LolaGUIHelper.getStatusColor(this._result.getStatus());
            this._figure.setAttribute("FrameColor", (Object)statusColor);
        } else {
            _logger.error((Object)"[Lola Task] Task seems to be not yet checked.");
        }
    }

    public void resetColor() {
        this._figure.setAttribute("FrameColor", (Object)ColorMap.NONE);
    }

    public String toString() {
        return this._formula;
    }

    public TextFigure getFigure() {
        return this._figure;
    }
}

