/*
 * Decompiled with CFR 0.152.
 */
package de.renew.layoutwindow;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingChangeEvent;
import CH.ifa.draw.framework.DrawingChangeListener;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.util.DrawingListener;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JFormattedTextField;
import org.apache.log4j.Logger;

public class PositionDimensionsTracker
implements DrawingListener,
DrawingChangeListener {
    private static final Logger LOGGER = Logger.getLogger(PositionDimensionsTracker.class);
    private final JFormattedTextField _xTextField;
    private final JFormattedTextField _yTextField;
    private final JFormattedTextField _widthTextField;
    private final JFormattedTextField _heightTextField;

    public PositionDimensionsTracker(final JFormattedTextField xTextField, final JFormattedTextField yTextField, final JFormattedTextField widthTextField, final JFormattedTextField heightTextField) {
        this._xTextField = xTextField;
        this._yTextField = yTextField;
        this._widthTextField = widthTextField;
        this._heightTextField = heightTextField;
        this._xTextField.addActionListener(e -> this.updateFigure());
        this._yTextField.addActionListener(e -> this.updateFigure());
        this._widthTextField.addActionListener(e -> this.updateFigure());
        this._heightTextField.addActionListener(e -> this.updateFigure());
        xTextField.setFocusTraversalKeys(0, Collections.emptySet());
        yTextField.setFocusTraversalKeys(0, Collections.emptySet());
        widthTextField.setFocusTraversalKeys(0, Collections.emptySet());
        heightTextField.setFocusTraversalKeys(0, Collections.emptySet());
        this._xTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 9) {
                    PositionDimensionsTracker.this.updateFigure();
                    yTextField.grabFocus();
                }
            }
        });
        this._yTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 9) {
                    PositionDimensionsTracker.this.updateFigure();
                    widthTextField.grabFocus();
                }
            }
        });
        this._widthTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 9) {
                    PositionDimensionsTracker.this.updateFigure();
                    heightTextField.grabFocus();
                }
            }
        });
        this._heightTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 9) {
                    PositionDimensionsTracker.this.updateFigure();
                    xTextField.grabFocus();
                }
            }
        });
        DrawApplication app = DrawPlugin.getGui();
        app.addDrawingListener((DrawingListener)this);
        Collections.list(app.drawings()).forEach(d -> d.addDrawingChangeListener((DrawingChangeListener)this));
    }

    private void updateFigure() {
        Vector selection = DrawPlugin.getGui().view().selection();
        if (selection.size() == 1) {
            try {
                int x = Integer.parseInt(this._xTextField.getText());
                int y = Integer.parseInt(this._yTextField.getText());
                int width = Integer.parseInt(this._widthTextField.getText());
                int height = Integer.parseInt(this._heightTextField.getText());
                Rectangle r = new Rectangle(x, y, width, height);
                Figure f = (Figure)selection.firstElement();
                f.displayBox(r);
                f.invalidate();
                f.changed();
                DrawPlugin.getGui().view().checkDamage();
            }
            catch (NumberFormatException e) {
                LOGGER.warn((Object)e.getMessage());
            }
        }
    }

    public void drawingReleased(Drawing drawing) {
        drawing.removeDrawingChangeListener((DrawingChangeListener)this);
    }

    public void drawingAdded(Drawing drawing) {
        drawing.addDrawingChangeListener((DrawingChangeListener)this);
    }

    public void drawingInvalidated(DrawingChangeEvent e) {
        Vector selection = DrawPlugin.getGui().view().selection();
        if (selection.size() == 1) {
            Figure f = (Figure)selection.firstElement();
            Rectangle r = f.displayBox();
            this._xTextField.setText("" + r.x);
            this._yTextField.setText("" + r.y);
            this._widthTextField.setText("" + r.width);
            this._heightTextField.setText("" + r.height);
        } else {
            this._xTextField.setText("");
            this._yTextField.setText("");
            this._widthTextField.setText("");
            this._heightTextField.setText("");
        }
    }

    public void drawingRequestUpdate(DrawingChangeEvent e) {
    }
}

