/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hamburg.fs;

import collections.HashedMap;
import collections.HashedSet;
import collections.UpdatableMap;
import collections.UpdatableSet;
import de.renew.util.ClassSource;
import de.uni_hamburg.fs.BasicType;
import de.uni_hamburg.fs.Concept;
import de.uni_hamburg.fs.ConceptImpl;
import de.uni_hamburg.fs.ConceptSet;
import de.uni_hamburg.fs.ConjunctiveType;
import de.uni_hamburg.fs.JavaConcept;
import de.uni_hamburg.fs.ListType;
import de.uni_hamburg.fs.Name;
import de.uni_hamburg.fs.ParsedConjunctiveType;
import de.uni_hamburg.fs.ParsedListType;
import de.uni_hamburg.fs.ParsedType;
import de.uni_hamburg.fs.Partition;
import de.uni_hamburg.fs.Type;
import de.uni_hamburg.fs.TypeException;
import de.uni_hamburg.fs.UnificationFailure;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class TypeSystem
implements Serializable {
    public static final Logger LOGGER = Logger.getLogger(TypeSystem.class);
    private static TypeSystem _instance = null;
    private ConceptImpl _root = new ConceptImpl();
    private Partition _topPartition;
    private UpdatableMap _concepts = new HashedMap();

    private void init() {
        this._topPartition = new Partition();
        this.transitiveClosure();
    }

    public void transitiveClosure() {
        this._root.transitiveClosure();
    }

    public void recalcDirectIsa() throws TypeException {
        this._root.transitiveClosure();
        this._root.recalcDirectIsa((UpdatableSet)new HashedSet());
    }

    public void inheritFeatures() throws UnificationFailure {
        this.recalcDirectIsa();
        this._root.inherit((UpdatableSet)new HashedSet());
        this._root.buildFeatureTypes((UpdatableSet)new HashedSet());
    }

    public Partition getTopPartition() {
        return this._topPartition;
    }

    public static TypeSystem instance() {
        if (_instance == null) {
            return TypeSystem.newInstance();
        }
        return _instance;
    }

    public static TypeSystem newInstance() {
        _instance = new TypeSystem();
        _instance.init();
        return _instance;
    }

    public static void setInstance(TypeSystem instance) {
        _instance = instance;
    }

    public ConceptImpl getRoot() {
        return this._root;
    }

    public void newRoot() {
        ConceptImpl newRoot = new ConceptImpl();
        this._root.basicAddIsa(newRoot);
        this._topPartition = new Partition();
        this._root = newRoot;
    }

    public void addConcept(Concept concept) {
        if (concept instanceof ConceptImpl) {
            ConceptImpl ci = (ConceptImpl)concept;
            ci.basicAddIsa(this._root);
            if (ci.isDummy()) {
                return;
            }
        }
        this._concepts.putAt((Object)new Name(concept.getFullName()), (Object)concept);
    }

    public void removeConcept(Concept concept) {
        this._concepts.removeAt((Object)concept.getFullName());
    }

    public boolean hasConcept(String name) {
        return this.hasConcept(new Name(name));
    }

    public boolean hasConcept(Name name) {
        if (this._concepts.includesKey((Object)name)) {
            return true;
        }
        try {
            this.getJavaClass(name.toString());
            return true;
        }
        catch (TypeException tee) {
            return false;
        }
    }

    public Concept conceptForName(String name) {
        return this.conceptForName(new Name(name));
    }

    public Concept conceptForName(Name name) {
        Concept concept = null;
        try {
            concept = (Concept)this._concepts.at((Object)name);
        }
        catch (NoSuchElementException nse) {
            try {
                concept = this.getJavaConcept(this.getJavaClass(name.toString()));
            }
            catch (TypeException tee) {
                LOGGER.debug((Object)("No concept found for name " + String.valueOf(name) + " in " + String.valueOf(this._concepts)));
                LOGGER.debug((Object)("Interpretation of name " + String.valueOf(name) + " as Java concept failed:"), (Throwable)tee);
                throw new NoSuchElementException("No concept found for name " + String.valueOf(name));
            }
        }
        return concept;
    }

    public JavaConcept getJavaConcept(Class<?> javaClass) {
        Concept concept;
        Name name = new Name(javaClass.getName());
        if (this._concepts.includesKey((Object)name) && (concept = (Concept)this._concepts.at((Object)name)) instanceof JavaConcept) {
            return (JavaConcept)concept;
        }
        JavaConcept jc = new JavaConcept(javaClass);
        this.addConcept(jc);
        return jc;
    }

    public Class<?> getJavaClass(String javaClassName) throws TypeException {
        try {
            return ClassSource.classForName((String)javaClassName);
        }
        catch (ClassNotFoundException cnf1) {
            throw new TypeException(cnf1);
        }
        catch (IllegalArgumentException iae) {
            throw new TypeException(iae);
        }
        catch (LinkageError le) {
            throw new TypeException(le);
        }
    }

    public Type getType(Class<?> javaClass) {
        if (javaClass.isPrimitive() || javaClass == String.class) {
            return new BasicType(javaClass);
        }
        if (javaClass.isArray()) {
            return new ListType(this.getType(javaClass.getComponentType()));
        }
        if (Enumeration.class.isAssignableFrom(javaClass)) {
            return new ListType(this.getType(Object.class));
        }
        return new ConjunctiveType(this.getJavaConcept(javaClass));
    }

    ParsedType getParsedType(Class<?> javaClass) {
        if (javaClass.isPrimitive() || javaClass == String.class) {
            return (ParsedType)((Object)this.getType(javaClass));
        }
        if (javaClass.isArray()) {
            return new ParsedListType(false, this.getParsedType(javaClass.getComponentType()));
        }
        if (Enumeration.class.isAssignableFrom(javaClass)) {
            return new ParsedListType(false, this.getParsedType(Object.class));
        }
        return new ParsedConjunctiveType(new ConceptSet(this.getJavaConcept(javaClass)));
    }
}

