/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hamburg.fs;

import de.uni_hamburg.fs.JavaFeature;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.apache.log4j.Logger;

class FieldFeature
extends JavaFeature {
    public static final Logger LOGGER = Logger.getLogger(FieldFeature.class);
    private Field _field;

    FieldFeature(Field field) {
        this._field = field;
    }

    @Override
    Class<?> getJavaClass() {
        return this._field.getType();
    }

    @Override
    Object getObjectValue(Object javaObject) {
        try {
            return this._field.get(javaObject);
        }
        catch (IllegalAccessException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException("Exception during feature setting:");
        }
    }

    @Override
    boolean canSet() {
        return !Modifier.isFinal(this._field.getModifiers());
    }

    @Override
    void setObjectValue(Object javaObject, Object value) {
        try {
            this._field.set(javaObject, value);
        }
        catch (IllegalAccessException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException("Exception during feature setting:");
        }
    }
}

