/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.fs;

import de.renew.formalism.fs.ShadowConcept;
import de.renew.shadow.ShadowInscribable;
import de.renew.shadow.ShadowInscription;
import de.uni_hamburg.fs.Name;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class ShadowAssoc
extends ShadowInscribable {
    public static final Logger LOGGER = Logger.getLogger(ShadowAssoc.class);
    public static final int ZERO_OR_ONE = 0;
    public static final int ZERO_OR_MORE = 1;
    public static final int ONE_OR_MORE = 2;
    private ShadowConcept _concept;
    private ShadowConcept _type;

    public ShadowAssoc(ShadowConcept concept, ShadowConcept type) {
        super(concept.getNet());
        this._concept = concept;
        this._type = type;
    }

    public ShadowConcept getConcept() {
        return this._concept;
    }

    public ShadowConcept getType() {
        return this._type;
    }

    public int getMultiplicity() {
        Iterator iterator = this.elements().iterator();
        while (iterator.hasNext()) {
            String inscr = ((ShadowInscription)iterator.next()).inscr.trim();
            if ("*".equals(inscr) || "0..*".equals(inscr)) {
                return 1;
            }
            if (!"1..*".equals(inscr)) continue;
            return 2;
        }
        return 0;
    }

    public Name getFeature() {
        Iterator iterator = this.elements().iterator();
        Object feature = null;
        boolean multi = false;
        while (iterator.hasNext() && feature == null) {
            String inscr = ((ShadowInscription)iterator.next()).inscr.trim();
            if (inscr.indexOf("*") >= 0) {
                multi = true;
                continue;
            }
            if (inscr.indexOf("..") >= 0) continue;
            feature = inscr;
        }
        if (feature == null) {
            feature = this._type.getName();
            int pos = ((String)feature).indexOf("::");
            if (pos >= 0) {
                feature = ((String)feature).substring(pos + 2);
            }
            feature = ((String)feature).substring(0, 1).toLowerCase() + ((String)feature).substring(1);
            if (multi) {
                feature = (String)feature + "s";
            }
            LOGGER.debug((Object)("Concept " + this._concept.getName() + " gets default feature name " + (String)feature));
        }
        return new Name((String)feature);
    }

    public void discard() {
    }
}

