/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.efsnet;

import collections.CollectionEnumeration;
import collections.HashedMap;
import collections.HashedSet;
import collections.LinkedList;
import collections.Seq;
import collections.UpdatableMap;
import de.renew.expression.CallExpression;
import de.renew.expression.ConstantExpression;
import de.renew.expression.EqualsExpression;
import de.renew.expression.Expression;
import de.renew.expression.Function;
import de.renew.expression.VariableExpression;
import de.renew.formalism.efsnet.EFSNetConstants;
import de.renew.formalism.efsnet.PlaceMarkingFunction;
import de.renew.formalism.efsnet.ProcessRuleFunction;
import de.renew.formalism.efsnet.ValueMarkingFunction;
import de.renew.formalism.fs.FSNetCompiler;
import de.renew.formalism.fs.FSNetParser;
import de.renew.formalism.fs.FSUnifyExpression;
import de.renew.formalism.fs.SingleFSNetCompiler;
import de.renew.formalism.fsnet.SingleXFSNetCompiler;
import de.renew.formalism.java.ArcInscription;
import de.renew.formalism.java.FlexibleOutArcFactory;
import de.renew.formalism.java.ParseException;
import de.renew.formalism.java.ParsedDeclarationNode;
import de.renew.formalism.java.TimedExpression;
import de.renew.formalism.java.TypedExpression;
import de.renew.net.ExpressionTokenSource;
import de.renew.net.Net;
import de.renew.net.NetElementID;
import de.renew.net.Place;
import de.renew.net.TokenSource;
import de.renew.net.Transition;
import de.renew.net.TransitionInscription;
import de.renew.net.arc.ClearArc;
import de.renew.net.inscription.ExpressionInscription;
import de.renew.shadow.ShadowArc;
import de.renew.shadow.ShadowInscription;
import de.renew.shadow.ShadowLookup;
import de.renew.shadow.ShadowNet;
import de.renew.shadow.ShadowPlace;
import de.renew.shadow.ShadowTransition;
import de.renew.shadow.SyntaxException;
import de.renew.util.Types;
import de.uni_hamburg.fs.ConceptImpl;
import de.uni_hamburg.fs.ConjunctiveType;
import de.uni_hamburg.fs.EquivRelation;
import de.uni_hamburg.fs.FSNode;
import de.uni_hamburg.fs.FeatureStructure;
import de.uni_hamburg.fs.Name;
import de.uni_hamburg.fs.Node;
import de.uni_hamburg.fs.ParsedConjunctiveType;
import de.uni_hamburg.fs.ParsedType;
import de.uni_hamburg.fs.Partition;
import de.uni_hamburg.fs.Path;
import de.uni_hamburg.fs.Type;
import de.uni_hamburg.fs.TypeException;
import de.uni_hamburg.fs.TypeSystem;
import de.uni_hamburg.fs.UnificationFailure;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;

public class SingleEFSNetCompiler
extends SingleFSNetCompiler
implements EFSNetConstants {
    public static final Logger LOGGER = Logger.getLogger(SingleEFSNetCompiler.class);
    public static boolean _valueSem = true;
    private Place _markingPlace = null;
    private Place _procPlace = null;
    private UpdatableMap _places = null;
    private UpdatableMap _transitions = null;

    protected void compile(ShadowPlace shadowPlace, Net net) throws SyntaxException {
        Place place;
        String pname = shadowPlace.getName();
        if (pname == null) {
            throw new SyntaxException("In Elementary FSNets, Places must have names.").addObject((Object)shadowPlace);
        }
        if (!pname.equals("proc") && !pname.equals("m")) {
            Object initialMarking = null;
            for (Object elem : shadowPlace.elements()) {
                if (!(elem instanceof ShadowInscription)) continue;
                if (initialMarking != null) {
                    throw new SyntaxException("EFSNets are only allowed to have one initial token per place.").addObject(elem);
                }
                initialMarking = ((ShadowInscription)elem).inscr;
            }
            initialMarking = initialMarking == null ? "[E]" : "[Tok val:" + (String)initialMarking + "]";
            this._places.putAt((Object)shadowPlace, initialMarking);
            LOGGER.debug((Object)("Initial Marking of " + pname + ": " + (String)initialMarking));
        }
        if (pname.equals("m") && this._markingPlace != null) {
            place = this._markingPlace;
        } else {
            place = new Place(net, pname, new NetElementID(shadowPlace.getID()));
            place.setTrace(shadowPlace.getTrace());
            this.getLookup().set(shadowPlace, place);
            if (pname.equals("m")) {
                this._markingPlace = place;
            }
        }
        if (pname.equals("proc")) {
            this._procPlace = place;
        }
    }

    protected void compile(ShadowTransition shadowTransition, Net net) throws SyntaxException {
        Name placeName;
        String tname = shadowTransition.getName();
        if (tname == null) {
            throw new SyntaxException("In Elementary FSNets, Transitions must have names.").addObject((Object)shadowTransition);
        }
        HashedMap dotT = new HashedMap();
        HashedMap tDot = new HashedMap();
        HashedSet allPlaces = new HashedSet();
        String transitionRule = null;
        for (Object elem : shadowTransition.elements()) {
            String arcTag;
            if (elem instanceof ShadowInscription) {
                if (transitionRule != null) {
                    throw new SyntaxException("EFSNets are only allowed to have one transition inscription (the rule).").addObject(elem);
                }
                ShadowInscription inscription = (ShadowInscription)elem;
                transitionRule = inscription.inscr;
                continue;
            }
            if (!(elem instanceof ShadowArc)) continue;
            ShadowArc shadowArc = (ShadowArc)elem;
            if (shadowArc.shadowArcType != 1 && shadowArc.shadowArcType != 2) {
                throw new SyntaxException("EFSNets only allow normal arcs.").addObject((Object)shadowArc);
            }
            Iterator arcInscriptions = shadowArc.elements().iterator();
            if (arcInscriptions.hasNext()) {
                ShadowInscription inscription = (ShadowInscription)arcInscriptions.next();
                if (arcInscriptions.hasNext()) {
                    throw new SyntaxException("EFSNets have to have exactly one arc inscription (a tag).").addObject((Object)inscription);
                }
                arcTag = inscription.inscr;
            } else {
                arcTag = "#root";
            }
            Name placeName2 = new Name(shadowArc.place.getName());
            allPlaces.include((Object)placeName2);
            if (shadowArc.shadowArcType == 2 || shadowArc.placeToTransition) {
                dotT.putAt((Object)placeName2, (Object)arcTag);
            }
            if (shadowArc.shadowArcType != 2 && shadowArc.placeToTransition) continue;
            tDot.putAt((Object)placeName2, (Object)arcTag);
        }
        if (transitionRule == null) {
            transitionRule = "[]";
        }
        StringBuffer transStr = new StringBuffer();
        transStr.append("[Tr").append('\n').append(" rule:#root").append(transitionRule).append('\n').append(" eff:[Eff\n").append("      pre:[M\n");
        CollectionEnumeration placeEnum = allPlaces.elements();
        while (placeEnum.hasMoreElements()) {
            placeName = (Name)placeEnum.nextElement();
            transStr.append("           ").append(placeName.toString()).append(':');
            if (dotT.includesKey((Object)placeName)) {
                transStr.append("[Tok val:").append(dotT.at((Object)placeName)).append("]");
            } else {
                transStr.append("[E]");
            }
            transStr.append('\n');
        }
        transStr.append("          ]\n      post:[M\n");
        placeEnum = allPlaces.elements();
        while (placeEnum.hasMoreElements()) {
            placeName = (Name)placeEnum.nextElement();
            transStr.append("            ").append(placeName.toString()).append(':');
            if (tDot.includesKey((Object)placeName)) {
                transStr.append("[Tok val:").append(tDot.at((Object)placeName)).append("]");
            } else {
                transStr.append("[E]");
            }
            transStr.append('\n');
        }
        transStr.append("           ]]]");
        this._transitions.putAt((Object)shadowTransition, (Object)transStr.toString());
        Transition transition = new Transition(net, tname, new NetElementID(shadowTransition.getID()));
        boolean trace = shadowTransition.getTrace();
        transition.setTrace(trace);
        this.getLookup().set(shadowTransition, transition);
    }

    public void compile(ShadowNet shadowNet) throws SyntaxException {
        this._places = new HashedMap();
        this._transitions = new HashedMap();
        this._procPlace = null;
        ShadowLookup lookup = this.getLookup();
        Net net = lookup.getNet(shadowNet.getName());
        super.compile(shadowNet);
        if (this._markingPlace == null) {
            this._markingPlace = new Place(net, "m", new NetElementID());
        }
        TypeSystem ts = TypeSystem.instance();
        String netSpace = shadowNet.getName() + "::";
        ConceptImpl m = new ConceptImpl(netSpace + "M");
        ConceptImpl token = new ConceptImpl(netSpace + "Token");
        ConceptImpl e = new ConceptImpl(netSpace + "E");
        ConceptImpl tok = new ConceptImpl(netSpace + "Tok");
        ConceptImpl tr = new ConceptImpl(netSpace + "Tr");
        ConceptImpl eff = new ConceptImpl(netSpace + "Eff");
        ConceptImpl pEff = new ConceptImpl(netSpace + "PEff");
        ConceptImpl proc = new ConceptImpl(netSpace + "Proc");
        Partition topPartition = ts.getTopPartition();
        try {
            topPartition.addConcept(m);
            topPartition.addConcept(token);
            topPartition.addConcept(tr);
            topPartition.addConcept(eff);
            topPartition.addConcept(proc);
            e.addIsa(token);
            tok.addIsa(token);
            Partition tokenSubPartition = new Partition(e);
            tokenSubPartition.addConcept(tok);
            pEff.addIsa(eff);
        }
        catch (TypeException tee) {
            LOGGER.error((Object)"Type Exception during internal TypeSystem construction!");
            return;
        }
        ParsedType ptTop = ParsedType.PARSED_TOP;
        tr.addApprop("rule", ptTop);
        ParsedConjunctiveType ptEff = new ParsedConjunctiveType(eff);
        tr.addApprop("eff", (ParsedType)ptEff);
        ParsedConjunctiveType ptM = new ParsedConjunctiveType(m);
        eff.addApprop(FEAT_PRE, (ParsedType)ptM);
        eff.addApprop(FEAT_POST, (ParsedType)ptM);
        ParsedConjunctiveType ptProc = new ParsedConjunctiveType(proc);
        pEff.addApprop(FEAT_POSTC, (ParsedType)ptM);
        pEff.addApprop(FEAT_PROC, (ParsedType)ptProc);
        proc.addApprop("m", (ParsedType)ptM);
        tok.addApprop("val", ptTop);
        ParsedConjunctiveType ptToken = new ParsedConjunctiveType(token);
        CollectionEnumeration sortedPlaceNames = this.sort((Enumeration<ShadowPlace>)this._places.keys()).elements();
        while (sortedPlaceNames.hasMoreElements()) {
            String place = (String)sortedPlaceNames.nextElement();
            m.addApprop(place, (ParsedType)ptToken);
            pEff.addApprop(place, (ParsedType)ptProc);
            proc.addApprop(place, (ParsedType)ptProc);
        }
        Partition procSubPartition = new Partition();
        CollectionEnumeration transEnum = this._transitions.keys();
        while (transEnum.hasMoreElements()) {
            ShadowTransition transition = (ShadowTransition)transEnum.nextElement();
            ConceptImpl transConcept = new ConceptImpl(netSpace + transition.getName());
            try {
                transConcept.addIsa(proc);
                procSubPartition.addConcept(transConcept);
            }
            catch (TypeException tee) {
                LOGGER.error((Object)"Type Exception during internal TypeSystem construction of Transition types!");
                return;
            }
        }
        Type tM = null;
        Type tProc = null;
        try {
            ts.inheritFeatures();
            tM = ptM.asType();
            tProc = ptProc.asType();
        }
        catch (UnificationFailure uff) {
            throw new SyntaxException("Something went wrong during feature inheritance:\n" + String.valueOf(uff), (Throwable)uff);
        }
        ParsedDeclarationNode declNode = this.makeDeclarationNode(shadowNet);
        CollectionEnumeration placeEnum = this._places.keys();
        FSNode placeRoot = new FSNode(tM);
        while (placeEnum.hasMoreElements()) {
            ShadowPlace splace = (ShadowPlace)placeEnum.nextElement();
            FeatureStructure placeFS = SingleEFSNetCompiler.parseFS(declNode, (String)this._places.at((Object)splace));
            Place place = lookup.get(splace);
            if (placeFS.getType().getName().equals("Tok")) {
                place.add((TokenSource)new ExpressionTokenSource((Expression)new ConstantExpression(FeatureStructure.class, (Object)placeFS.at("val"))));
            }
            placeRoot.setFeature(new Name(splace.getName()), placeFS.getRoot());
        }
        FeatureStructure initMarking = new FeatureStructure(placeRoot);
        LOGGER.debug((Object)("Initial Marking:" + String.valueOf(initMarking)));
        this._markingPlace.add((TokenSource)new ExpressionTokenSource((Expression)new ConstantExpression(FeatureStructure.class, (Object)initMarking)));
        if (this._procPlace != null) {
            FSNode initProc = new FSNode(tProc);
            initProc.setFeature(FEAT_M, initMarking.getRoot());
            this._procPlace.add((TokenSource)new ExpressionTokenSource((Expression)new ConstantExpression(FeatureStructure.class, (Object)new FeatureStructure(initProc))));
        }
        transEnum = this._transitions.keys();
        while (transEnum.hasMoreElements()) {
            ShadowTransition trans = (ShadowTransition)transEnum.nextElement();
            String transString = (String)this._transitions.at((Object)trans);
            FeatureStructure transFS = SingleEFSNetCompiler.parseFS(declNode, transString).at("eff");
            FeatureStructure dTransFS = this.copymark(transFS);
            Transition transition = lookup.get(trans);
            VariableExpression pre = SingleXFSNetCompiler.getVariableExpression("pre");
            this.getArcFactory(-1, true).compileArc(this._markingPlace, transition, trans.getTrace(), Types.UNTYPED, (ArcInscription)new TimedExpression(new TypedExpression(Types.UNTYPED, (Expression)pre), null));
            VariableExpression post = SingleXFSNetCompiler.getVariableExpression("post");
            Vector<Path> paths = new Vector<Path>();
            paths.add(PATH_PRE);
            CallExpression postExpr = SingleXFSNetCompiler.getFSAtExpression(new FSUnifyExpression(dTransFS, paths, SingleEFSNetCompiler.makeVector(pre)), PATH_POST);
            if (_valueSem) {
                postExpr = new CallExpression(Types.UNTYPED, (Expression)postExpr, (Function)ValueMarkingFunction.INSTANCE);
            }
            transition.add((TransitionInscription)new ExpressionInscription((Expression)new EqualsExpression(Types.UNTYPED, (Expression)post, (Expression)postExpr)));
            this.getArcFactory(1, true).compileArc(this._markingPlace, transition, trans.getTrace(), Types.UNTYPED, (ArcInscription)new TimedExpression(new TypedExpression(Types.UNTYPED, (Expression)post), null));
            if (this._procPlace != null) {
                VariableExpression procExp = SingleXFSNetCompiler.getVariableExpression("proc");
                this.getArcFactory(-1, true).compileArc(this._procPlace, transition, false, Types.UNTYPED, (ArcInscription)new TimedExpression(new TypedExpression(Types.UNTYPED, (Expression)procExp), null));
                CallExpression newProc = new CallExpression(Types.UNTYPED, (Expression)procExp, (Function)new ProcessRuleFunction(_valueSem, SingleEFSNetCompiler.processRule(trans.getName(), transFS)));
                this.getArcFactory(1, true).compileArc(this._procPlace, transition, false, Types.UNTYPED, (ArcInscription)new TimedExpression(new TypedExpression(Types.UNTYPED, (Expression)newProc), null));
            }
            placeEnum = this._places.keys();
            while (placeEnum.hasMoreElements()) {
                ShadowPlace splace = (ShadowPlace)placeEnum.nextElement();
                Place place = lookup.get(splace);
                ClearArc arc = new ClearArc(place, transition, (Expression)new VariableExpression(Types.UNTYPED, null), Object.class);
                arc.setTrace(false);
                transition.add((TransitionInscription)arc);
                CallExpression outExpr = new CallExpression(Types.UNTYPED, (Expression)post, (Function)new PlaceMarkingFunction(place.getName()));
                FlexibleOutArcFactory._instance.compileArc(place, transition, trans.getTrace(), Types.UNTYPED, (ArcInscription)new TimedExpression(new TypedExpression(Types.UNTYPED, (Expression)outExpr), null));
            }
        }
    }

    private static Vector<Object> makeVector(Object obj) {
        Vector<Object> v = new Vector<Object>(1);
        v.addElement(obj);
        return v;
    }

    public static FeatureStructure parseFS(ParsedDeclarationNode declNode, String fsStr) throws SyntaxException {
        FSNetParser fsParser = new FSNetParser(new StringReader(fsStr));
        fsParser.setDeclarationNode(declNode);
        HashedMap tags = new HashedMap();
        EquivRelation er = new EquivRelation();
        try {
            Node root = fsParser.parseFS((UpdatableMap)tags, er, Path.EPSILON, new Vector<Path>(), new Vector<Object>());
            er.extensionalize();
            root = er.rebuild(root);
            return new FeatureStructure(root);
        }
        catch (ParseException ex) {
            throw FSNetCompiler.makeSyntaxException(ex);
        }
        catch (Exception uff) {
            throw new SyntaxException("FS not extensionalizable!", (Throwable)uff);
        }
    }

    public FeatureStructure copymark(FeatureStructure rule) {
        Node pre = rule.delta(FEAT_PRE);
        CollectionEnumeration placeEnum = this._places.keys();
        while (placeEnum.hasMoreElements()) {
            Name placeName = new Name(((ShadowPlace)placeEnum.nextElement()).getName());
            if (pre.hasFeature(placeName)) continue;
            try {
                rule = rule.equate(PATH_PRE.append(placeName), PATH_POST.append(placeName));
            }
            catch (UnificationFailure uff) {
                throw new RuntimeException("Internal Error in copymark:\n" + String.valueOf(uff) + "\nRule:" + String.valueOf(rule) + "placeName: " + String.valueOf(placeName));
            }
        }
        return rule;
    }

    static String getNamespace(Type t) {
        String fullname = t.getFullName();
        return fullname.substring(0, fullname.indexOf("::") + 2);
    }

    public static FeatureStructure processRule(String transition, FeatureStructure transRule) {
        Type ttrans;
        Type m;
        Type proc;
        Type pEff;
        String netSpace = SingleEFSNetCompiler.getNamespace(transRule.getType());
        try {
            pEff = ConjunctiveType.getType(netSpace + "PEff");
            proc = ConjunctiveType.getType(netSpace + "Proc");
            m = ConjunctiveType.getType(netSpace + "M");
            ttrans = ConjunctiveType.getType(netSpace + transition);
        }
        catch (UnificationFailure uff) {
            LOGGER.error((Object)("Type " + netSpace + "PEff, Proc, M, or " + transition + " not found!"));
            return null;
        }
        FSNode processRule = new FSNode(pEff);
        processRule.setFeature(FEAT_PRE, transRule.delta(FEAT_PRE));
        processRule.setFeature(FEAT_POST, transRule.delta(FEAT_POST));
        FSNode mcopy = new FSNode(m);
        processRule.setFeature(FEAT_POSTC, mcopy);
        FSNode tNode = new FSNode(ttrans);
        tNode.setFeature(FEAT_M, mcopy);
        Node pre = transRule.delta(FEAT_PRE);
        CollectionEnumeration placeNames = pre.featureNames();
        while (placeNames.hasMoreElements()) {
            Name placeName = (Name)placeNames.nextElement();
            FSNode pNode = new FSNode(proc);
            pNode.setFeature(placeName, tNode);
            processRule.setFeature(placeName, pNode);
        }
        return new FeatureStructure(processRule, false);
    }

    private Seq sort(Enumeration<ShadowPlace> elems) {
        LinkedList sorted = new LinkedList();
        while (elems.hasMoreElements()) {
            String elem = elems.nextElement().getName();
            boolean goon = true;
            for (int i = 0; goon && i < sorted.size(); ++i) {
                String sortedStr = (String)sorted.at(i);
                if (sortedStr.compareTo(elem) <= 0) continue;
                sorted.insertAt(i, (Object)elem);
                goon = false;
            }
            if (!goon) continue;
            sorted.insertLast((Object)elem);
        }
        return sorted;
    }
}

