
<!-- Adapted from: https://www.writethedocs.org/guide/writing/beginners-guide-to-docs/ -->

# FAFormalism

## User Guide

The plugin allows for simulating finite automata models that have been drawn with the FA plugin.
Refer to the user guide in the doc/-directory for a more extensive explanation.

### Features

- Simulate a finite automata model that has been drawn with the FA plugin
- Visualize the simulation

### Example Usage

To create a new FA model:

1. Open the GUI
2. Create a new file of the type `.fa` (File -> New Drawing)
3. Tools -> FA Drawing Tool -> FA Drawing Tools
4. Use the new tools that became available to create an FA model

This plugin provides two different formalisms, "FA Net Compiler" and "FA Automaton Compiler".

The Fa Net Compiler allows for arcs to be inscribed with up- and downlinks and works in multi-formalism simulations.
Outside multi-formalism simulations, however, the FA Net Compiler does not interpret any arc inscriptions aside from 
code expression or Java method calls.

The FA Automaton Compiler can be used to simulate (non-)deterministic finite automata and Buechi automata.
The arc inscriptions may only contain single letters, or multiple letters, separated by commas. For PDAs, an arc's inscription may
only be of the format "x,y->z", where x, y and z may be left empty. If they are left empty or only contain blanks, they are considered to be an epsilon.
Several inscriptions can be connected by separating them with 
a line break.
Again, alphabet letters may only be single letters or a number.
The start state may have a (omega-)regular expression attached to it.
During the simulation, the automaton will be simulated as it processes the input. Arcs may only be traversed if the
expression allows it. For PDAs, the current stack will be displayed in the top left corner of the simulation. 

Simulate the FA model:

1. Simulation -> Formalisms -> Select the FA Net compiler or FA Automaton Compiler
2. Run the simulation with Simulation -> Run Simulation(Ctrl+R) / Simulations Step (Ctrl+I)

A more detailed user guide (both English and German version) for the usage can be found in the doc-folder.
Be sure to also consult the README.md of the FA plugin.

### Provided Commands

<!-- Use the classes implementing CLCommand. The 'help' output of the command can be a useful description -->

No commands are provided.

### Installation

Install _FAFormalism_ by putting the JAR file inside the `dist/plugins` directory.

It will be automatically loaded at startup of Renew.
### Dependencies

This plugin depends on the following plugins and external libraries:

<!-- must match the `module-info.java` -->

- `Formalism` - Provides support for the net compiler
- `log4j`: Logging Framework

### Configuration

FAFormalism does not offer configuration options.

## Developer Guide

### Core Classes

- `FANetCompiler`: Compiles a single FA-net for multi formalism simulations.
- `FAAutomatonCompiler`: Compiles a single FA drawing for automaton simulations.
- `AutomatonModelEnum`: Defines all recognized automaton models accepted by the FAAutomatonCompiler.
- `FAAutomatonSimulationHelper`: The engine running the simulation for the FAAutomatonCompiler. Extend "fire()" and "canFire()" to implement new automaton models.
- `FAFormalismPlugin`: Wrapper-class for the FAFormalism Plugin. It extends `Plugin Adapter` to manage the startup and shutdown.

### How to Extend

_FAFormalism_ doesn't expose any interfaces.
However, new automaton types can be implemented easily by adding new types to FAAutomatonModelEnum 
and adding functionality to the methods fire and canFire in the FAAutomatonSimulationHelper.

The current FAAutomatonCompiler translates states into places.
Arcs connecting two states are translated into an intermediate transition connecting the two places.
Example:

Automaton: _s0_ --a--> _s1_

Compiled net: _p0_ --x--> _t_ --y--> _p1_

The transition _t_ will have the inscription "guard(canFire(x, a)); action y = fire(x)".
When firing, the transition calls the methods "canFire" and "fire" from the FAAutomatonSimulationHelper. These methods
accept a tuple containing the current word and, for PDAs, the current stack, otherwise null. Additionally, "fire(x)" returns
a tuple with the updated word and the current stack.
Extend these methods to implement new behaviour, such as GNFAs.

### Additional Information

<!-- Common issues, explanations for inconsistencies, etc. -->

None.

<!-- Contribution Info -->

<!-- License -->