/*
 * Decompiled with CFR 0.152.
 */
package de.renew.unify;

import de.renew.unify.Aggregate;
import de.renew.unify.Copier;
import de.renew.unify.Reference;
import de.renew.unify.StateRecorder;
import de.renew.unify.TupleIterator;
import java.util.Iterator;

public final class Tuple
extends Aggregate {
    public static final Tuple NULL = new Tuple(0);

    public Tuple(int arity) {
        super(arity);
    }

    public Tuple(Object[] initValues, StateRecorder recorder) {
        super(initValues, recorder);
    }

    public int getArity() {
        return this.getReferences().length;
    }

    public Object getComponent(int i) {
        return this.getReferences()[i].getValue();
    }

    @Override
    public Iterator<Object> iterator() {
        return new TupleIterator(this);
    }

    @Override
    public int length() {
        return this.getArity();
    }

    public Tuple copy(Copier copier) {
        Reference[] references = this.getReferences();
        if (references.length == 0) {
            return NULL;
        }
        Object[] dest = new Object[references.length];
        for (int i = 0; i < references.length; ++i) {
            dest[i] = copier.copy(references[i].getValue());
        }
        return new Tuple(dest, null);
    }

    public int hashCode() {
        Reference[] references = this.getReferences();
        int result = references.length + 71;
        for (int i = 0; i < references.length; ++i) {
            result = result * 41 + this.refHash(i);
        }
        return result;
    }

    public boolean equals(Object obj) {
        return obj instanceof Tuple && this.matches((Aggregate)obj);
    }

    public String toString() {
        Reference[] references = this.getReferences();
        StringBuilder result = new StringBuilder();
        result.append('[');
        for (int i = 0; i < references.length; ++i) {
            if (i > 0) {
                result.append(',');
            }
            if (references[i].getValue() == null) {
                result.append("null");
                continue;
            }
            result.append(references[i].getValue().toString());
        }
        result.append(']');
        return result.toString();
    }
}

