/*
 * Decompiled with CFR 0.152.
 */
package de.renew.unify;

import de.renew.unify.Aggregate;
import de.renew.unify.Copier;
import de.renew.unify.ListIterator;
import de.renew.unify.Reference;
import de.renew.unify.StateRecorder;
import java.util.Iterator;

public final class List
extends Aggregate {
    public static final List NULL = new List(0);

    public List(int arity) {
        super(arity);
        if (arity != 2 && arity != 0) {
            throw new RuntimeException("Illegal list element size.");
        }
    }

    public List(Object head, Object tail, StateRecorder recorder) {
        super(new Object[]{head, tail}, recorder);
    }

    public boolean isNull() {
        return this.getReferences().length == 0;
    }

    public Object head() {
        return this.getReferences()[0].getValue();
    }

    public Object tail() {
        return this.getReferences()[1].getValue();
    }

    @Override
    public Iterator<Object> iterator() {
        return new ListIterator(this);
    }

    @Override
    public int length() {
        int length = 0;
        List current = this;
        while (!current.isNull()) {
            ++length;
            current = (List)current.tail();
        }
        return length;
    }

    public List append(List that) {
        if (this.isNull()) {
            return that;
        }
        Object object = this.tail();
        if (object instanceof List) {
            List tail = (List)object;
            return new List(this.head(), tail.append(that), null);
        }
        return new List(this.head(), that, null);
    }

    public List copy(Copier copier) {
        Reference[] references = this.getReferences();
        if (references.length == 0) {
            return NULL;
        }
        return new List(copier.copy(references[0].getValue()), copier.copy(references[1].getValue()), null);
    }

    public int hashCode() {
        if (this.getReferences().length == 0) {
            return 73;
        }
        return this.refHash(0) + 43 * this.refHash(1);
    }

    public boolean equals(Object obj) {
        return obj instanceof List && this.matches((Aggregate)obj);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append('{');
        List listCopy = this;
        boolean prependComma = false;
        while (listCopy.getReferences().length != 0) {
            if (listCopy.getReferences().length == 1) {
                throw new RuntimeException("Somebody took the hashcode of a delegator.");
            }
            if (prependComma) {
                result.append(',');
            } else {
                prependComma = true;
            }
            Object headValue = listCopy.getReferences()[0].getValue();
            if (headValue == null) {
                result.append("null");
            } else {
                result.append(headValue);
            }
            Object tailValue = listCopy.getReferences()[1].getValue();
            if (tailValue instanceof List) {
                listCopy = (List)tailValue;
                continue;
            }
            result.append(':');
            if (tailValue == null) {
                result.append("null");
            } else {
                result.append(tailValue);
            }
            listCopy = NULL;
        }
        result.append('}');
        return result.toString();
    }
}

