/*
 * Decompiled with CFR 0.152.
 */
package de.renew.unify;

import de.renew.unify.BacklinkSet;
import de.renew.unify.IdentityWrapper;
import de.renew.unify.Impossible;
import de.renew.unify.Notifiable;
import de.renew.unify.RecorderChecker;
import de.renew.unify.Referable;
import de.renew.unify.Reference;
import de.renew.unify.Referer;
import de.renew.unify.StateRecorder;
import de.renew.unify.Unifiable;
import de.renew.unify.Unify;
import de.renew.unify.Unknown;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.IntStream;

public abstract class Aggregate
implements Unifiable,
Referable,
Referer,
Serializable {
    private BacklinkSet _backlinkSet;
    private final transient RecorderChecker _recorderChecker;
    private final Reference[] _references;
    private boolean _complete;
    private boolean _bound;

    Aggregate(int arity) {
        this._recorderChecker = new RecorderChecker(null);
        this._references = Unify.makeUnknownReferenceArray(arity, this);
        this._complete = arity == 0;
        boolean bl = this._bound = arity == 0;
        if (!this._complete) {
            this._backlinkSet = new BacklinkSet();
        }
    }

    Aggregate(Object[] initValues, StateRecorder recorder) {
        this._recorderChecker = new RecorderChecker(recorder);
        this._references = Unify.cleanupReferenceArray(initValues, this, recorder);
        this._complete = this.calculateComplete();
        this._bound = this.calculateBound();
        if (!this._complete) {
            this._backlinkSet = new BacklinkSet();
        }
    }

    public Object[] asArray(Class<?> destType) {
        return this.copyInto((Object[])Array.newInstance(destType, this._references.length));
    }

    public Object[] asArray() {
        return this.copyInto(new Object[this._references.length]);
    }

    public Object[] copyInto(Object[] result) {
        for (int i = 0; i < this._references.length; ++i) {
            result[i] = this._references[i].getValue();
        }
        return result;
    }

    public Reference[] getReferences() {
        return this._references;
    }

    private boolean calculateComplete() {
        return Arrays.stream(this._references).allMatch(Reference::isComplete);
    }

    private boolean calculateBound() {
        return Arrays.stream(this._references).allMatch(Reference::isBound);
    }

    @Override
    public boolean isComplete() {
        return this._complete;
    }

    @Override
    public boolean isBound() {
        return this._bound;
    }

    @Override
    public void possiblyCompleted(Set<Notifiable> listeners, StateRecorder recorder) throws Impossible {
        if (this._references.length == 0) {
            throw new RuntimeException("An empty aggregate became completed.");
        }
        if (!this._complete && this.calculateComplete()) {
            if (recorder != null) {
                recorder.record(() -> {
                    this._complete = false;
                });
            }
            this._complete = true;
            if (this.calculateBound()) {
                if (recorder != null) {
                    recorder.record(() -> {
                        this._bound = false;
                    });
                }
                this._bound = true;
            }
            this.checkBacklinkSet();
            this._backlinkSet.updateBacklinked(this, this, listeners, recorder);
            BacklinkSet oldBacklinkSet = this._backlinkSet;
            if (recorder != null) {
                recorder.record(() -> {
                    this._backlinkSet = oldBacklinkSet;
                });
            }
            this._backlinkSet = null;
        }
    }

    private void checkBacklinkSet() {
        if (this._backlinkSet == null) {
            if (!this._complete) {
                throw new RuntimeException("A complete object received a backlink. Strange");
            }
            throw new RuntimeException("An incomplete object lacks a backlink set. Strange");
        }
    }

    @Override
    public void addBacklink(Reference reference, StateRecorder recorder) {
        this._recorderChecker.checkRecorder(recorder);
        this.checkBacklinkSet();
        this._backlinkSet.addBacklink(reference, recorder);
    }

    void unifySilently(Aggregate that, StateRecorder recorder, Set<Notifiable> listeners) throws Impossible {
        if (that._references.length != this._references.length) {
            throw new Impossible();
        }
        for (int i = 0; i < this._references.length; ++i) {
            Unify.unifySilently(this._references[i].getValue(), that._references[i].getValue(), recorder, listeners);
        }
    }

    @Override
    public void occursCheck(Unknown that, Set<IdentityWrapper> visited) throws Impossible {
        if (this._complete) {
            return;
        }
        IdentityWrapper thisWrapper = new IdentityWrapper(this);
        if (visited.contains(thisWrapper)) {
            return;
        }
        visited.add(thisWrapper);
        for (Reference reference : this._references) {
            reference.occursCheck(that, visited);
        }
    }

    boolean matches(Aggregate that) {
        if (this._references.length != that._references.length) {
            return false;
        }
        return IntStream.range(0, this._references.length).allMatch(index -> Objects.equals(this._references[index].getValue(), that._references[index].getValue()));
    }

    protected int refHash(int i) {
        if (this._references[i].getValue() == null) {
            return 1;
        }
        return this._references[i].getValue().hashCode();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (!this.isComplete()) {
            throw new NotSerializableException("de.renew.unify.Aggregate: " + String.valueOf(this) + " is not complete.");
        }
        out.defaultWriteObject();
    }

    public abstract Iterator<Object> iterator();

    public abstract int length();
}

