/*
 * Decompiled with CFR 0.152.
 */
package de.renew.shadow;

import de.renew.shadow.ShadowInscribable;
import de.renew.shadow.ShadowNet;
import de.renew.shadow.ShadowNode;
import java.io.IOException;
import java.io.ObjectInputStream;

public abstract class ShadowConnection
extends ShadowInscribable {
    public boolean trace;
    public ShadowNode from;
    public ShadowNode to;

    protected ShadowConnection(ShadowNode from, ShadowNode to) {
        super(ShadowConnection.ensureIdentity(from, to));
        this.from = from;
        this.to = to;
        from.add(this);
        to.add(this);
    }

    private static ShadowNet ensureIdentity(ShadowNode from, ShadowNode to) {
        ShadowNet net;
        if (from == null | to == null) {
            throw new RuntimeException("Connection must be connected at both ends.");
        }
        ShadowNet shadowNet = net = from != null ? from.getNet() : null;
        if (to != null && net != to.getNet()) {
            throw new RuntimeException("Must connect within one net.");
        }
        return net;
    }

    public boolean getTrace() {
        return this.trace;
    }

    public void setTrace(boolean trace) {
        if (this.trace != trace) {
            this.trace = trace;
        }
    }

    @Override
    public void discard() {
        this.from.remove(this);
        this.to.remove(this);
        super.discard();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.from.add(this);
        this.to.add(this);
    }
}

