/*
 * Decompiled with CFR 0.152.
 */
package de.renew.shadow;

import de.renew.net.loading.Finder;
import de.renew.shadow.ShadowNet;
import de.renew.shadow.ShadowNetSystem;
import de.renew.util.ClassSource;
import de.renew.util.ObjectInputStreamUsingBottomLoader;
import de.renew.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class SNSFinder
extends Finder {
    public static Logger logger = Logger.getLogger(SNSFinder.class);
    private final String[] shadowExtensions = new String[]{".sns", ".sha"};

    @Override
    public ShadowNetSystem findNetFile(String name, String path) {
        boolean error = true;
        URL url = null;
        for (int ext = 0; error && ext < this.shadowExtensions.length; ++ext) {
            error = false;
            String fullFileName = path + this.shadowExtensions[ext];
            logger.debug((Object)("SNSFinder: looking for: " + fullFileName));
            try {
                File file = new File(fullFileName);
                if (file.canRead()) {
                    url = file.toURI().toURL();
                } else {
                    error = true;
                }
            }
            catch (Exception e) {
                logger.error((Object)("SNSFinder: " + fullFileName + " caused " + String.valueOf(e)));
                logger.debug((Object)e.getMessage(), (Throwable)e);
                error = true;
            }
            if (error) continue;
            try {
                ShadowNetSystem netSystem = this.loadNetSystemFromURL(url, name);
                if (netSystem == null) continue;
                return netSystem;
            }
            catch (Exception e) {
                logger.error((Object)("SNSFinder: " + String.valueOf(url) + " caused " + String.valueOf(e)));
                logger.debug((Object)e.getMessage(), (Throwable)e);
                error = true;
            }
        }
        return null;
    }

    @Override
    public ShadowNetSystem findNetClasspathRel(String name, String path) {
        boolean error = true;
        for (int ext = 0; error && ext < this.shadowExtensions.length; ++ext) {
            error = false;
            String fullFileName = path + this.shadowExtensions[ext];
            logger.debug((Object)("SNSFinder: looking for: " + fullFileName));
            URL url = ClassSource.getClassLoader().getResource(StringUtil.convertToSlashes((String)fullFileName));
            boolean bl = error = url == null;
            if (error) continue;
            try {
                ShadowNetSystem netSystem = this.loadNetSystemFromURL(url, name);
                if (netSystem == null) continue;
                return netSystem;
            }
            catch (Exception e) {
                logger.error((Object)("SNSFinder: " + String.valueOf(url) + " caused " + String.valueOf(e)));
                logger.debug((Object)e.getMessage(), (Throwable)e);
                error = true;
            }
        }
        return null;
    }

    private ShadowNetSystem loadNetSystemFromURL(URL url, String name) throws IOException, ClassNotFoundException {
        logger.debug((Object)("Loading shadow net from " + String.valueOf(url)));
        InputStream stream = url.openStream();
        ObjectInputStreamUsingBottomLoader input = new ObjectInputStreamUsingBottomLoader(stream);
        ShadowNetSystem netSystem = (ShadowNetSystem)input.readObject();
        input.close();
        Iterator<ShadowNet> nets = netSystem.elements().iterator();
        if (nets.hasNext()) {
            ShadowNet net = nets.next();
            if (nets.hasNext()) {
                logger.error((Object)("SNSFinder: " + String.valueOf(url) + " contains more than one shadow net. Ignored."));
            } else if (net.getName().equals(name)) {
                logger.debug((Object)("SNSFinder: found net " + name + " at " + String.valueOf(url)));
                return netSystem;
            }
        }
        logger.warn((Object)("SNSFinder: " + String.valueOf(url) + " was empty!? Ignored."));
        return null;
    }
}

