/*
 * Decompiled with CFR 0.152.
 */
package de.renew.shadow;

import de.renew.application.SimulatorPlugin;
import de.renew.net.Net;
import de.renew.net.NetNotFoundException;
import de.renew.net.loading.NetLoader;
import de.renew.shadow.ShadowLookup;
import de.renew.shadow.ShadowNetLoader;
import de.renew.shadow.ShadowNetSystem;

public class DefaultCompiledNetLoader
implements NetLoader {
    private ShadowNetLoader netLoader;

    public DefaultCompiledNetLoader(ShadowNetLoader netLoader) {
        if (netLoader == null) {
            throw new NullPointerException("Missing ShadowNetLoader.");
        }
        this.netLoader = netLoader;
    }

    @Override
    public Net loadNet(String netName) throws NetNotFoundException {
        try {
            Net result;
            ShadowNetSystem netSystem = this.netLoader.loadShadowNetSystem(netName);
            ShadowLookup lookup = SimulatorPlugin.getCurrent().insertNets(netSystem);
            if (lookup != null && (result = lookup.getNet(netName)) != null) {
                return result;
            }
        }
        catch (NetNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NetNotFoundException(netName, e);
        }
        throw new NetNotFoundException(netName);
    }
}

