/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net.arc;

import de.renew.engine.common.SimulatorEventLogger;
import de.renew.engine.common.StepIdentifier;
import de.renew.engine.events.Putting;
import de.renew.engine.events.SimulationEvent;
import de.renew.engine.searcher.LateExecutable;
import de.renew.engine.searchqueue.SearchQueue;
import de.renew.net.PlaceInstance;
import de.renew.net.SimulatablePlaceInstance;
import de.renew.net.TransitionInstance;
import de.renew.unify.Variable;
import de.renew.util.Value;

class OutputArcExecutable
implements LateExecutable {
    SimulatablePlaceInstance pInstance;
    TransitionInstance tInstance;
    Variable tokenVar;
    Variable timeVar;
    boolean trace;

    OutputArcExecutable(SimulatablePlaceInstance pInstance, TransitionInstance tInstance, Variable tokenVar, Variable timeVar, boolean trace) {
        this.pInstance = pInstance;
        this.tInstance = tInstance;
        this.tokenVar = tokenVar;
        this.timeVar = timeVar;
        this.trace = trace;
    }

    @Override
    public int phase() {
        return 3;
    }

    @Override
    public boolean isLong() {
        return false;
    }

    @Override
    public void execute(StepIdentifier stepIdentifier) {
        double time = SearchQueue.getTime();
        if (this.timeVar != null) {
            time += ((Value)this.timeVar.getValue()).doubleValue();
        }
        if (this.trace) {
            SimulatorEventLogger.log(stepIdentifier, (SimulationEvent)new Putting(this.tokenVar.getValue(), this.pInstance, time), (PlaceInstance)this.pInstance);
        }
        this.pInstance.insertToken(this.tokenVar.getValue(), time);
    }

    @Override
    public void executeAfterException(StepIdentifier stepIdentifier, Throwable t) {
    }
}

