/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net.arc;

import de.renew.engine.common.SimulatorEventLogger;
import de.renew.engine.common.StepIdentifier;
import de.renew.engine.events.Putting;
import de.renew.engine.events.SimulationEvent;
import de.renew.engine.searcher.LateExecutable;
import de.renew.engine.searchqueue.SearchQueue;
import de.renew.net.PlaceInstance;
import de.renew.net.SimulatablePlaceInstance;
import de.renew.net.TransitionInstance;
import de.renew.net.arc.FlexibleArc;
import de.renew.unify.Impossible;
import de.renew.unify.List;
import de.renew.unify.Variable;
import de.renew.util.Value;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;

class FlexibleOutArcExecutable
implements LateExecutable {
    SimulatablePlaceInstance pInstance;
    TransitionInstance tInstance;
    Variable tokenVar;
    FlexibleArc arc;

    FlexibleOutArcExecutable(SimulatablePlaceInstance placeInstance, TransitionInstance tInstance, Variable tokenVar, FlexibleArc arc) {
        this.pInstance = placeInstance;
        this.tInstance = tInstance;
        this.tokenVar = tokenVar;
        this.arc = arc;
    }

    @Override
    public int phase() {
        return 3;
    }

    @Override
    public boolean isLong() {
        return false;
    }

    private void putSingleToken(StepIdentifier stepIdentifier, Object tok) {
        if (this.arc.forwardFunction != null) {
            try {
                tok = this.arc.forwardFunction.function(tok);
            }
            catch (Impossible impossible) {
                // empty catch block
            }
        }
        if (this.arc.getTrace()) {
            SimulatorEventLogger.log(stepIdentifier, (SimulationEvent)new Putting(tok, this.pInstance), (PlaceInstance)this.pInstance);
        }
        this.pInstance.insertToken(tok, SearchQueue.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(StepIdentifier stepIdentifier) {
        block17: {
            Object tokens = this.tokenVar.getValue();
            this.pInstance.lock.lock();
            try {
                if (tokens == null) {
                    break block17;
                }
                if (tokens instanceof Iterator) {
                    Iterator i = (Iterator)tokens;
                    while (i.hasNext()) {
                        this.putSingleToken(stepIdentifier, i.next());
                    }
                    break block17;
                }
                if (tokens instanceof Enumeration) {
                    Enumeration enumeration = (Enumeration)tokens;
                    while (enumeration.hasMoreElements()) {
                        this.putSingleToken(stepIdentifier, enumeration.nextElement());
                    }
                    break block17;
                }
                if (tokens.getClass().isArray()) {
                    int n = Array.getLength(tokens);
                    Class<?> elementType = tokens.getClass().getComponentType();
                    for (int i = 0; i < n; ++i) {
                        Object tok = Array.get(tokens, i);
                        if (elementType.isPrimitive()) {
                            tok = new Value(tok);
                        }
                        this.putSingleToken(stepIdentifier, tok);
                    }
                    break block17;
                }
                if (tokens instanceof List) {
                    List current = (List)tokens;
                    while (!current.isNull()) {
                        this.putSingleToken(stepIdentifier, current.head());
                        if (!(current.tail() instanceof List)) {
                            break block17;
                        }
                        current = (List)current.tail();
                    }
                    break block17;
                }
                if (tokens instanceof Collection) {
                    Collection coll = (Collection)tokens;
                    Iterator i = coll.iterator();
                    while (i.hasNext()) {
                        this.putSingleToken(stepIdentifier, i.next());
                    }
                } else {
                    this.putSingleToken(stepIdentifier, tokens);
                }
            }
            finally {
                this.pInstance.lock.unlock();
            }
        }
    }

    @Override
    public void executeAfterException(StepIdentifier stepIdentifier, Throwable t) {
    }
}

