/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net.arc;

import de.renew.engine.searcher.Occurrence;
import de.renew.engine.searcher.Searcher;
import de.renew.expression.Expression;
import de.renew.expression.VariableMapper;
import de.renew.net.NetInstance;
import de.renew.net.Place;
import de.renew.net.Transition;
import de.renew.net.TransitionInscription;
import de.renew.net.arc.ArcOccurrence;
import java.util.Collection;
import java.util.Vector;

public class Arc
implements TransitionInscription {
    public static final int in = -1;
    public static final int test = 0;
    public static final int out = 1;
    public static final int both = 2;
    public static final int fastBoth = 3;
    public static final int fastTest = 4;
    public static final int inhibitor = 5;
    public static final int bothOT = 6;
    protected Place place;
    protected Transition transition;
    protected int arcType;
    protected Expression tokenExpr;
    protected Expression timeExpr;
    boolean trace;

    public Arc(Place place, Transition transition, int arcType, Expression tokenExpr, Expression timeExpr) {
        if (arcType < -1 || arcType > 6) {
            throw new RuntimeException("Bad arc type: " + arcType + ".");
        }
        this.place = place;
        this.transition = transition;
        this.arcType = arcType;
        this.tokenExpr = tokenExpr;
        this.timeExpr = timeExpr;
        this.trace = true;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public boolean getTrace() {
        return this.trace;
    }

    public boolean isTestArc() {
        return this.arcType == 0 || this.arcType == 4;
    }

    public boolean isUntimedArc() {
        return this.isTestArc() || this.arcType == 5;
    }

    @Override
    public Collection<Occurrence> makeOccurrences(VariableMapper mapper, NetInstance netInstance, Searcher searcher) {
        Vector<Occurrence> coll = new Vector<Occurrence>();
        coll.add(new ArcOccurrence(this, mapper, netInstance));
        return coll;
    }
}

