/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net;

import de.renew.application.SimulatorPlugin;
import de.renew.engine.common.StepIdentifier;
import de.renew.engine.searcher.Searchable;
import de.renew.engine.searcher.Searcher;
import de.renew.engine.searcher.TriggerCollection;
import de.renew.engine.searcher.TriggerCollectionImpl;
import de.renew.engine.searcher.Triggerable;
import de.renew.engine.searcher.UplinkProvider;
import de.renew.engine.searchqueue.SearchQueue;
import de.renew.engine.simulator.ExecuteFinder;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.engine.simulator.SimulatorHelper;
import de.renew.net.NetInstance;
import de.renew.net.Transition;
import de.renew.net.TransitionOccurrence;
import de.renew.net.event.FiringEvent;
import de.renew.net.event.TransitionEventListener;
import de.renew.net.event.TransitionEventListenerSet;
import de.renew.net.event.TransitionEventProducer;
import de.renew.unify.Impossible;
import de.renew.unify.Variable;
import de.renew.util.DelayedFieldOwner;
import de.renew.util.RenewObjectInputStream;
import de.renew.util.RenewObjectOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class TransitionInstance
implements Searchable,
Triggerable,
UplinkProvider,
TransitionEventProducer,
Serializable,
DelayedFieldOwner {
    static final long serialVersionUID = -2146903280470015837L;
    private NetInstance netInstance;
    private Transition transition;
    private transient TriggerCollection triggers = new TriggerCollectionImpl(this);
    private transient Set<FiringEvent> pendingEvents = new HashSet<FiringEvent>();
    private transient TransitionEventListenerSet listeners = new TransitionEventListenerSet();
    private transient Runnable executeAfterDeserialization = null;

    TransitionInstance(NetInstance netInstance, Transition transition) {
        this.netInstance = netInstance;
        this.transition = transition;
    }

    public String toString() {
        return this.netInstance.toString() + "." + this.transition.toString();
    }

    public NetInstance getNetInstance() {
        return this.netInstance;
    }

    public Transition getTransition() {
        return this.transition;
    }

    @Override
    public TriggerCollection triggers() {
        return this.triggers;
    }

    @Override
    public void addTransitionEventListener(TransitionEventListener listener) {
        this.listeners.addTransitionEventListener(listener);
    }

    @Override
    public void removeTransitionEventListener(TransitionEventListener listener) {
        this.listeners.removeTransitionEventListener(listener);
    }

    @Override
    public void proposeSearch() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        if (this.transition.isSpontaneous()) {
            SearchQueue.includeNow(this);
        }
    }

    synchronized void firingStarted(FiringEvent fe) {
        this.pendingEvents.add(fe);
        this.listeners.firingStarted(fe);
        this.transition.getListenerSet().firingStarted(fe);
    }

    synchronized void firingComplete(FiringEvent fe) {
        this.pendingEvents.remove(fe);
        this.listeners.firingComplete(fe);
        this.transition.getListenerSet().firingComplete(fe);
    }

    public Iterator<FiringEvent> pendingFiringEvents() {
        return this.pendingEvents.iterator();
    }

    public synchronized boolean isFiring() {
        return !this.pendingEvents.isEmpty();
    }

    void createConfirmation() {
        if (this.transition.isSpontaneous()) {
            SearchQueue.includeNow(this);
        }
    }

    public boolean listensToChannel(String channel) {
        return this.transition.listensToChannel(channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAndSearchOccurrence(Variable params, Searcher searcher) {
        int checkpoint = searcher.recorder.checkpoint();
        try {
            searcher.search(new TransitionOccurrence(this, params, searcher));
        }
        catch (Impossible impossible) {
        }
        finally {
            searcher.recorder.restore(checkpoint);
        }
    }

    @Override
    public void bindChannel(Variable params, Searcher searcher) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.createAndSearchOccurrence(params, searcher);
    }

    @Override
    public void startSearch(Searcher searcher) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.createAndSearchOccurrence(null, searcher);
        searcher.recorder.restore();
    }

    public boolean fireOneBinding(boolean asynchronous, Searcher searcher) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        ExecuteFinder finder = new ExecuteFinder();
        SimulatorHelper.searchOnce(searcher, finder, this, this);
        StepIdentifier step = SimulatorPlugin.getCurrent().getCurrentEnvironment().getSimulator().nextStepIdentifier();
        if (finder.isCompleted()) {
            finder.execute(step, asynchronous);
            return true;
        }
        return false;
    }

    public boolean fireOneBinding(boolean asynchronous) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        Searcher searcher = new Searcher();
        return this.fireOneBinding(asynchronous, searcher);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        RenewObjectOutputStream rOut = null;
        if (out instanceof RenewObjectOutputStream) {
            rOut = (RenewObjectOutputStream)out;
        }
        if (rOut != null) {
            rOut.beginDomain((Object)this);
        }
        if (this.pendingEvents.isEmpty()) {
            out.defaultWriteObject();
            if (rOut != null) {
                rOut.delayedWriteObject((Object)this.triggers, (DelayedFieldOwner)this);
            } else {
                out.writeObject(this.triggers);
            }
        } else {
            throw new NotSerializableException("Active bindings  at transition instance " + String.valueOf(this));
        }
        if (rOut != null) {
            rOut.endDomain((Object)this);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        in.defaultReadObject();
        this.pendingEvents = new HashSet<FiringEvent>();
        this.listeners = new TransitionEventListenerSet();
        if (in instanceof RenewObjectInputStream) {
            RenewObjectInputStream rIn = (RenewObjectInputStream)in;
            if (rIn.isCopiousBehaviour()) {
                final TransitionInstance tiRef = this;
                this.executeAfterDeserialization = new Runnable(){

                    @Override
                    public void run() {
                        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
                        if (TransitionInstance.this.transition.isSpontaneous()) {
                            SearchQueue.includeNow(tiRef);
                        }
                    }
                };
            }
        } else {
            this.triggers = (TriggerCollection)in.readObject();
        }
    }

    public void reassignField(Object value) throws IOException {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        if (value instanceof TriggerCollection) {
            this.triggers = (TriggerCollection)value;
            if (this.executeAfterDeserialization != null) {
                this.executeAfterDeserialization.run();
                this.executeAfterDeserialization = null;
            }
        } else {
            throw new NotSerializableException("Value of unexpected type given to reassign().");
        }
    }
}

