/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net;

import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.net.ManualInscription;
import de.renew.net.Net;
import de.renew.net.NetElementID;
import de.renew.net.TransitionInscription;
import de.renew.net.UplinkInscription;
import de.renew.net.event.TransitionEventListener;
import de.renew.net.event.TransitionEventListenerSet;
import de.renew.net.event.TransitionEventProducer;
import de.renew.util.RenewObjectOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class Transition
implements Serializable,
TransitionEventProducer {
    static final long serialVersionUID = -7955261691016471176L;
    NetElementID id;
    private final String name;
    String comment;
    private boolean trace;
    public UplinkInscription uplink;
    Set<TransitionInscription> inscriptions;
    private transient TransitionEventListenerSet listeners = new TransitionEventListenerSet();

    public Transition(Net net, String name, NetElementID id) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.id = id;
        this.name = name;
        this.trace = true;
        this.uplink = null;
        this.inscriptions = new HashSet<TransitionInscription>();
        net.add(this);
    }

    public NetElementID getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public boolean getTrace() {
        return this.trace;
    }

    public boolean isSpontaneous() {
        return this.uplink == null && !this.inscriptions.contains(ManualInscription.getInstance());
    }

    public boolean listensToChannel(String channel) {
        return this.uplink != null && this.uplink.name.equals(channel);
    }

    private void checkUplink() {
        this.uplink = null;
        for (TransitionInscription inscription : this.inscriptions) {
            if (!(inscription instanceof UplinkInscription)) continue;
            this.uplink = (UplinkInscription)inscription;
        }
    }

    public UplinkInscription getUplink() {
        return this.uplink;
    }

    public void add(TransitionInscription transitionInscription) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        if (!this.inscriptions.contains(transitionInscription)) {
            this.inscriptions.add(transitionInscription);
            this.checkUplink();
        }
    }

    public void remove(TransitionInscription transitionInscription) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        if (this.inscriptions.contains(transitionInscription)) {
            this.inscriptions.remove(transitionInscription);
            this.checkUplink();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        RenewObjectOutputStream rOut = null;
        if (out instanceof RenewObjectOutputStream) {
            rOut = (RenewObjectOutputStream)out;
        }
        if (rOut != null) {
            rOut.beginDomain((Object)this);
        }
        out.defaultWriteObject();
        if (rOut != null) {
            rOut.endDomain((Object)this);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        in.defaultReadObject();
        this.listeners = new TransitionEventListenerSet();
    }

    @Override
    public void addTransitionEventListener(TransitionEventListener listener) {
        this.listeners.addTransitionEventListener(listener);
    }

    @Override
    public void removeTransitionEventListener(TransitionEventListener listener) {
        this.listeners.removeTransitionEventListener(listener);
    }

    TransitionEventListenerSet getListenerSet() {
        return this.listeners;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    public Set<TransitionInscription> inscriptions() {
        return this.inscriptions;
    }

    public static boolean isManual(Transition transition) {
        return transition.inscriptions.contains(ManualInscription.getInstance());
    }
}

