/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net;

import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.net.SimulatablePlaceInstance;
import de.renew.net.TestTokenBag;
import de.renew.net.TimeSet;
import de.renew.net.TokenBag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

class TokenReservation {
    private SimulatablePlaceInstance instance;
    private int reservations;
    private TestTokenBag testedTokens;
    private TokenBag removedTokenDelays;

    TokenReservation(SimulatablePlaceInstance instance) {
        this.instance = instance;
        this.reservations = 0;
        this.testedTokens = new TestTokenBag();
        this.removedTokenDelays = new TokenBag();
    }

    boolean isRemovable() {
        return this.reservations == 0;
    }

    private TimeSet getRemovedDelaySet(Object token, boolean isTested) {
        TimeSet delays = this.removedTokenDelays.getTimeSet(token);
        if (isTested && !this.instance.containsTestedToken(token)) {
            delays = delays.including(0.0);
        }
        return delays;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double computeEarliestTime() {
        double result;
        this.instance.lock.lock();
        try {
            result = 0.0;
            HashSet<Object> tokens = new HashSet<Object>();
            tokens.addAll(this.testedTokens.uniqueElements());
            tokens.addAll(this.removedTokenDelays.uniqueElements());
            for (Object e : tokens) {
                boolean bl = this.testedTokens.getTestMultiplicity(e) > 0;
                TimeSet delays = this.getRemovedDelaySet(e, bl);
                double time = this.instance.computeEarliestTime(e, delays);
                if (!(time > result)) continue;
                result = time;
            }
        }
        finally {
            this.instance.lock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsRemovableToken(Object token, double delay) {
        boolean result;
        this.instance.lock.lock();
        try {
            TimeSet delays = this.getRemovedDelaySet(token, this.testedTokens.getTestMultiplicity(token) > 0).including(delay);
            double time = this.instance.computeEarliestTime(token, delays);
            result = time < Double.POSITIVE_INFINITY;
        }
        finally {
            this.instance.lock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsTestableToken(Object token) {
        boolean result;
        this.instance.lock.lock();
        try {
            TimeSet delays = this.getRemovedDelaySet(token, true);
            double time = this.instance.computeEarliestTime(token, delays);
            result = time < Double.POSITIVE_INFINITY;
        }
        finally {
            this.instance.lock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeToken(Object token, double delay) {
        boolean result;
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.instance.lock.lock();
        try {
            result = this.containsRemovableToken(token, delay);
            if (result) {
                this.removedTokenDelays.add(token, delay);
                ++this.reservations;
            }
        }
        finally {
            this.instance.lock.unlock();
        }
        return result;
    }

    public boolean testToken(Object token) {
        boolean result;
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.instance.lock.lock();
        try {
            result = this.containsTestableToken(token);
            if (result) {
                this.testedTokens.addTested(token, 0.0);
                ++this.reservations;
            }
        }
        finally {
            this.instance.lock.unlock();
        }
        return result;
    }

    public void unremoveToken(Object token, double delay) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.removedTokenDelays.removeOneOf(token, delay);
        --this.reservations;
    }

    public void untestToken(Object token) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.testedTokens.removeTested(token);
        --this.reservations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Object> getRemovableTokens(Object pattern) {
        ArrayList<Object> result = new ArrayList<Object>();
        this.instance.lock.lock();
        try {
            for (Object token : this.instance.getDistinctTokens(pattern)) {
                if (!this.containsRemovableToken(token, Double.NEGATIVE_INFINITY)) continue;
                result.add(token);
            }
        }
        finally {
            this.instance.lock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Object> getTestableTokens(Object pattern) {
        ArrayList<Object> result = new ArrayList<Object>();
        this.instance.lock.lock();
        try {
            for (Object token : this.instance.getDistinctTestableTokens(pattern)) {
                if (!this.containsTestableToken(token)) continue;
                result.add(token);
            }
        }
        finally {
            this.instance.lock.unlock();
        }
        return result;
    }
}

