/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net;

import de.renew.engine.searchqueue.SearchQueue;
import de.renew.net.TimeSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;

public class TokenBag
implements Serializable {
    private int size = 0;
    private Map<Object, TimeSet> map = new HashMap<Object, TimeSet>();

    TokenBag() {
    }

    public double computeEarliestTime(Object elem, TimeSet delays) {
        if (this.map.containsKey(elem)) {
            double earliest = this.map.get(elem).computeEarliestTime(delays);
            return earliest;
        }
        if (delays.getSize() == 0) {
            return 0.0;
        }
        return Double.POSITIVE_INFINITY;
    }

    public synchronized TimeSet getTimeSet(Object elem) {
        if (this.map.containsKey(elem)) {
            return this.map.get(elem);
        }
        return TimeSet.EMPTY;
    }

    public synchronized int getMultiplicity(Object elem) {
        if (this.map.containsKey(elem)) {
            return this.map.get(elem).getSize();
        }
        return 0;
    }

    public synchronized Collection<Object> uniqueElements() {
        return new ArrayList<Object>(this.map.keySet());
    }

    public synchronized boolean includesAnytime(Object elem) {
        return this.map.containsKey(elem);
    }

    public synchronized boolean includesBefore(Object elem, double time) {
        if (!this.map.containsKey(elem)) {
            return false;
        }
        TimeSet times = this.map.get(elem);
        return time >= times.earliestTime();
    }

    void add(Object elem, double time) {
        this.add(elem, time, 1);
    }

    synchronized void add(Object elem, double time, int n) {
        TimeSet times = this.map.get(elem);
        this.map.put(elem, times != null ? times.including(time, n) : TimeSet.make(time, n));
        this.size += n;
    }

    synchronized void removeOneOf(Object elem, double time) {
        if (this.map.containsKey(elem)) {
            TimeSet times = this.map.get(elem).excluding(time);
            if (times.isEmpty()) {
                this.map.remove(elem);
            } else {
                this.map.put(elem, times);
            }
            --this.size;
        } else {
            throw new RuntimeException("Negative number of tokens detected.");
        }
    }

    synchronized double removeWithDelay(Object elem, double delay) {
        if (this.map.containsKey(elem)) {
            TimeSet times = this.map.get(elem);
            double time = times.latestWithDelay(delay, SearchQueue.getTime());
            if ((times = times.excluding(time)).isEmpty()) {
                this.map.remove(elem);
            } else {
                this.map.put(elem, times);
            }
            --this.size;
            return time;
        }
        throw new NoSuchElementException();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("TokenBag(size: ");
        buffer.append(this.size);
        buffer.append("; token@timeset:");
        for (Object token : this.map.keySet()) {
            buffer.append(' ');
            buffer.append(token);
            buffer.append('@');
            buffer.append(this.map.get(token));
        }
        buffer.append(')');
        return buffer.toString();
    }
}

