/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class TestTokenBag
implements Serializable {
    static final int maxStaticMult = 15;
    static final Integer[] multiplicities = new Integer[16];
    private int size = 0;
    private Map<Object, Integer> testCount = new HashMap<Object, Integer>();
    private Map<Object, Double> orgTime = new HashMap<Object, Double>();

    TestTokenBag() {
    }

    public synchronized int getUniqueSize() {
        return this.testCount.size();
    }

    public synchronized int getTestMultiplicity(Object elem) {
        if (this.testCount.containsKey(elem)) {
            return this.testCount.get(elem);
        }
        return 0;
    }

    private static final Integer toInteger(int result) {
        if (result <= 15) {
            return multiplicities[result];
        }
        return result;
    }

    public synchronized Collection<Object> uniqueElements() {
        return new ArrayList<Object>(this.testCount.keySet());
    }

    public synchronized boolean includesTested(Object elem) {
        return this.testCount.containsKey(elem);
    }

    synchronized void addTested(Object elem, double time) {
        if (this.testCount.containsKey(elem)) {
            Integer num = this.testCount.get(elem);
            this.testCount.put(elem, TestTokenBag.toInteger(num + 1));
        } else {
            this.testCount.put(elem, TestTokenBag.toInteger(1));
            this.orgTime.put(elem, time);
        }
        ++this.size;
    }

    synchronized double removeTested(Object elem) {
        if (this.testCount.containsKey(elem)) {
            int newMult = this.testCount.get(elem) - 1;
            double time = this.orgTime.get(elem);
            if (newMult == 0) {
                this.testCount.remove(elem);
                this.orgTime.remove(elem);
            } else {
                this.testCount.put(elem, TestTokenBag.toInteger(newMult));
            }
            --this.size;
            return time;
        }
        throw new RuntimeException("Negative number of tokens detected.");
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("TestTokenBag(size: ");
        buffer.append(this.size);
        buffer.append("; count'token@time:");
        for (Object token : this.testCount.keySet()) {
            buffer.append(' ');
            buffer.append(this.testCount.get(token));
            buffer.append('\'');
            buffer.append(token);
            buffer.append('@');
            buffer.append(this.orgTime.get(token));
        }
        buffer.append(')');
        return buffer.toString();
    }

    static {
        for (int i = 0; i <= 15; ++i) {
            TestTokenBag.multiplicities[i] = i;
        }
    }
}

