/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net;

import de.renew.application.SimulatorPlugin;
import de.renew.engine.common.SimulatorEventLogger;
import de.renew.engine.common.StepIdentifier;
import de.renew.engine.events.NetInstantiationException;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.net.NetElementID;
import de.renew.net.NetInstance;
import de.renew.net.NetInstanceImpl;
import de.renew.net.NetNotFoundException;
import de.renew.net.Place;
import de.renew.net.Transition;
import de.renew.net.loading.NetLoader;
import de.renew.unify.Impossible;
import de.renew.util.ClassSource;
import de.renew.util.RenewObjectInputStream;
import de.renew.util.RenewObjectOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class Net
implements Serializable {
    public static Logger logger = Logger.getLogger(Net.class);
    static final long serialVersionUID = 4424943946669800287L;
    private static Map<String, Net> netsByName = new HashMap<String, Net>();
    private static NetLoader netLoader = null;
    Set<Place> places = new HashSet<Place>();
    Set<Transition> transitions = new HashSet<Transition>();
    Map<NetElementID, Place> placesByID = new HashMap<NetElementID, Place>();
    Map<NetElementID, Transition> transitionsByID = new HashMap<NetElementID, Transition>();
    String name = null;
    boolean earlyTokens = false;
    private int netCount = 0;

    public Net() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.name = null;
    }

    public Net(String name) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.name = name;
    }

    public static Net forName(final String name) throws NetNotFoundException {
        SimulatorPlugin.lock.lock();
        try {
            Future<Net> future = SimulationThreadPool.getCurrent().submitAndWait(new Callable<Net>(){

                @Override
                public Net call() throws Exception {
                    Net net = netsByName.get(name);
                    if (net == null) {
                        if (netLoader == null) {
                            throw new NetNotFoundException(name);
                        }
                        net = netsByName.get(name);
                        if (net == null) {
                            net = netLoader.loadNet(name);
                        }
                    }
                    return net;
                }
            });
            Net net = future.get();
            return net;
        }
        catch (InterruptedException e) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)e);
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof NetNotFoundException) {
                throw (NetNotFoundException)t;
            }
            logger.error((Object)"Simulation thread threw an exception", (Throwable)e);
        }
        finally {
            SimulatorPlugin.lock.unlock();
        }
        return null;
    }

    public static void forgetAllNets() {
        SimulatorPlugin.lock.lock();
        try {
            netsByName.clear();
        }
        finally {
            SimulatorPlugin.lock.unlock();
        }
    }

    public static void setNetLoader(NetLoader loader) {
        block4: {
            SimulatorPlugin.lock.lock();
            try {
                if (netsByName.isEmpty()) {
                    netLoader = loader;
                    break block4;
                }
                throw new IllegalStateException("Cannot change net loader while nets are known.");
            }
            finally {
                SimulatorPlugin.lock.unlock();
            }
        }
    }

    public static NetLoader getNetLoader() {
        return netLoader;
    }

    public static Iterator<Net> allKnownNets() {
        return netsByName.values().iterator();
    }

    public static boolean isKnownNet(String name) {
        return netsByName.containsKey(name);
    }

    public void makeKnown() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        SimulatorPlugin.lock.lock();
        try {
            if (this.name != null) {
                netsByName.put(this.name, this);
            }
        }
        finally {
            SimulatorPlugin.lock.unlock();
        }
    }

    public Collection<Place> places() {
        return this.places;
    }

    public int placeCount() {
        return this.places.size();
    }

    public Collection<Transition> transitions() {
        return this.transitions;
    }

    public int transitionCount() {
        return this.transitions.size();
    }

    synchronized int makeNetNumber() {
        return ++this.netCount;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public NetInstance makeInstance() throws Impossible {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        return new NetInstanceImpl(this);
    }

    public NetInstance buildInstance(StepIdentifier stepIdentifier) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        NetInstance instance = null;
        try {
            instance = this.makeInstance();
            instance.createConfirmation(stepIdentifier);
            return instance;
        }
        catch (Impossible e) {
            RuntimeException re = new RuntimeException("Could not make instance of net " + this.getName() + ".", e);
            SimulatorEventLogger.log(stepIdentifier, new NetInstantiationException(this, e));
            throw re;
        }
    }

    public NetInstance buildInstance() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        return this.buildInstance(SimulatorPlugin.getCurrent().getCurrentEnvironment().getSimulator().currentStepIdentifier());
    }

    void add(Place place) {
        NetElementID id = place.getID();
        assert (!this.places.contains(place)) : "Tried to add existing place: " + String.valueOf(place);
        assert (!this.placesByID.containsKey(id)) : "Tried to add place with existing ID: " + String.valueOf(id) + ", old: " + String.valueOf(this.placesByID.get(id)) + ", new: " + String.valueOf(place);
        this.places.add(place);
        this.placesByID.put(id, place);
    }

    void add(Transition transition) {
        NetElementID id = transition.getID();
        assert (!this.transitions.contains(transition)) : "Tried to add existing transition: " + String.valueOf(transition);
        assert (!this.transitionsByID.containsKey(id)) : "Tried to add transition with existing ID: " + String.valueOf(id) + ", old: " + String.valueOf(this.transitionsByID.get(id)) + ", new: " + String.valueOf(transition);
        this.transitions.add(transition);
        this.transitionsByID.put(id, transition);
    }

    void remove(Place place) {
        this.places.remove(place);
        this.placesByID.remove(place.getID());
    }

    void remove(Transition transition) {
        this.transitions.remove(transition);
        this.transitionsByID.remove(transition.getID());
    }

    public void setEarlyTokens(boolean earlyTokens) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.earlyTokens = earlyTokens;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        RenewObjectOutputStream rOut = null;
        if (out instanceof RenewObjectOutputStream) {
            rOut = (RenewObjectOutputStream)out;
        }
        if (rOut != null) {
            rOut.beginDomain((Object)this);
        }
        out.defaultWriteObject();
        if (rOut != null) {
            rOut.endDomain((Object)this);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        RenewObjectInputStream rIn;
        in.defaultReadObject();
        if (in instanceof RenewObjectInputStream && (rIn = (RenewObjectInputStream)in).isCopiousBehaviour()) {
            StringBuffer newName = new StringBuffer(this.name);
            while (Net.isKnownNet(newName.toString())) {
                newName.append("_COPY");
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Deserialized Net copy: changed name from " + this.name + " to " + String.valueOf(newName) + "."));
            }
            this.name = newName.toString();
        }
        this.makeKnown();
    }

    public static void saveAllNets(ObjectOutput output) throws IOException {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        SimulatorPlugin.lock.lock();
        try {
            RenewObjectOutputStream rOut = null;
            if (output instanceof RenewObjectOutputStream) {
                rOut = (RenewObjectOutputStream)output;
            }
            if (rOut != null) {
                rOut.beginDomain(Net.class);
            }
            output.writeInt(netsByName.size());
            Iterator<Net> iterator = netsByName.values().iterator();
            while (iterator.hasNext()) {
                output.writeObject(iterator.next());
            }
            if (rOut != null) {
                rOut.writeDelayedObjects();
            }
            if (rOut != null) {
                rOut.endDomain(Net.class);
            }
        }
        finally {
            SimulatorPlugin.lock.unlock();
        }
    }

    public static void loadNets(ObjectInput input) throws IOException, ClassNotFoundException {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        int count = input.readInt();
        try {
            for (int i = 0; i < count; ++i) {
                ClassSource.readObject((ObjectInput)input);
            }
        }
        catch (ClassCastException e) {
            logger.debug((Object)e.getMessage(), (Throwable)e);
            throw new StreamCorruptedException("Object other than Net found when looking for nets: " + e.getMessage());
        }
        if (input instanceof RenewObjectInputStream) {
            ((RenewObjectInputStream)input).readDelayedObjects();
        }
    }

    public Place getPlaceWithID(NetElementID id) {
        return this.placesByID.get(id);
    }

    public Transition getTransitionWithID(NetElementID id) {
        return this.transitionsByID.get(id);
    }
}

