/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net;

import de.renew.database.Transaction;
import de.renew.database.TransactionSource;
import de.renew.engine.searchqueue.SearchQueue;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.net.NetInstance;
import de.renew.net.Place;
import de.renew.net.SimulatablePlaceInstance;
import de.renew.net.TestTokenBag;
import de.renew.net.TimeSet;
import de.renew.net.TokenBag;
import de.renew.net.event.TokenEvent;
import de.renew.unify.Impossible;
import de.renew.unify.TupleIndex;
import de.renew.util.DelayedFieldOwner;
import de.renew.util.RenewObjectInputStream;
import de.renew.util.RenewObjectOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class MultisetPlaceInstance
extends SimulatablePlaceInstance {
    public static Logger logger = Logger.getLogger(MultisetPlaceInstance.class);
    static final long serialVersionUID = 0L;
    private int freeTokenCount;
    private int testedTokenCount;
    private transient TokenBag freeTokens;
    private transient TestTokenBag testedTokens;
    private transient TupleIndex freeIndex;
    private transient TupleIndex testIndex;

    MultisetPlaceInstance(NetInstance netInstance, Place place, boolean wantInitialTokens) throws Impossible {
        super(netInstance, place, wantInitialTokens);
    }

    @Override
    protected void initTokenStorage() {
        this.freeTokens = new TokenBag();
        this.testedTokens = new TestTokenBag();
        this.freeTokenCount = 0;
        this.testedTokenCount = 0;
        this.freeIndex = new TupleIndex();
        this.testIndex = new TupleIndex();
    }

    @Override
    public Set<Object> getDistinctTokens() {
        return this.freeIndex.getAllElements();
    }

    @Override
    public Set<Object> getDistinctTokens(Object pattern) {
        return this.freeIndex.getPossibleMatches(pattern);
    }

    @Override
    public Set<Object> getDistinctTestableTokens() {
        return this.testIndex.getAllElements();
    }

    @Override
    public Set<Object> getDistinctTestableTokens(Object pattern) {
        return this.testIndex.getPossibleMatches(pattern);
    }

    @Override
    public int getNumberOfTokens() {
        return this.freeTokenCount;
    }

    @Override
    public int getNumberOfTestedTokens() {
        return this.testedTokenCount;
    }

    @Override
    boolean containsToken(Object token) {
        return this.freeTokens.includesAnytime(token);
    }

    @Override
    public int getTokenCount(Object token) {
        return this.freeTokens.getMultiplicity(token);
    }

    @Override
    public TimeSet getFreeTimeSet(Object token) {
        return this.freeTokens.getTimeSet(token);
    }

    @Override
    public double computeEarliestTime(Object token, TimeSet times) {
        return this.freeTokens.computeEarliestTime(token, times);
    }

    @Override
    public boolean containsTestedToken(Object token) {
        return this.testedTokens.includesTested(token);
    }

    @Override
    public boolean containsTestableToken(Object token) {
        return this.containsToken(token) || this.containsTestedToken(token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double removeToken(Object token, double delay) throws Impossible {
        double removedTime;
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.lock.lock();
        try {
            removedTime = 0.0;
            try {
                removedTime = this.freeTokens.removeWithDelay(token, delay);
            }
            catch (Exception e) {
                throw new Impossible(e);
            }
            --this.freeTokenCount;
            if (!this.freeTokens.includesAnytime(token)) {
                this.freeIndex.remove(token);
                if (!this.testedTokens.includesTested(token)) {
                    this.testIndex.remove(token);
                }
            }
            Transaction transaction = TransactionSource.get();
            try {
                transaction.removeToken(this, token, removedTime);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            this.triggerables.proposeSearch();
            TokenEvent te = new TokenEvent(this, token);
            this.listeners.tokenRemoved(te);
            this.place.getListenerSet().tokenRemoved(te);
            this.unreserve(token);
        }
        finally {
            this.lock.unlock();
        }
        return removedTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double testToken(Object token) throws Impossible {
        double removedTime;
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.lock.lock();
        try {
            boolean wantNotify = false;
            removedTime = SearchQueue.getTime();
            if (!this.testedTokens.includesTested(token)) {
                try {
                    removedTime = this.freeTokens.removeWithDelay(token, 0.0);
                }
                catch (Exception e) {
                    throw new Impossible(e);
                }
                ++this.testedTokenCount;
                --this.freeTokenCount;
                if (!this.freeTokens.includesAnytime(token)) {
                    this.freeIndex.remove(token);
                }
                wantNotify = true;
            }
            this.testedTokens.addTested(token, removedTime);
            if (wantNotify) {
                this.triggerables.proposeSearch();
                TokenEvent te = new TokenEvent(this, token);
                this.listeners.tokenTested(te);
                this.place.getListenerSet().tokenTested(te);
            }
        }
        finally {
            this.lock.unlock();
        }
        return removedTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void extractAllTokens(Vector<Object> tokens, Vector<Double> timeStamps) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.lock.lock();
        try {
            ArrayList<Object> uniqueValues = new ArrayList<Object>(this.getDistinctTokens());
            while (!uniqueValues.isEmpty()) {
                Object token = uniqueValues.remove(uniqueValues.size() - 1);
                while (this.containsToken(token)) {
                    double time = 0.0;
                    try {
                        time = this.removeToken(token, Double.NEGATIVE_INFINITY);
                    }
                    catch (Impossible e) {
                        throw new RuntimeException("Token was not removable.", e);
                    }
                    if (tokens != null) {
                        tokens.addElement(token);
                    }
                    if (timeStamps == null) continue;
                    timeStamps.addElement(time);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void internallyInsertToken(Object token, double time, boolean alreadyRegistered) {
        this.internallyInsertTokenMultiple(token, time, 1, alreadyRegistered);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internallyInsertTokenMultiple(Object token, double time, int n, boolean alreadyRegistered) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        assert (n > 0) : "trying to insert non-positive number of tokens";
        this.lock.lock();
        try {
            if (!this.freeTokens.includesAnytime(token)) {
                this.freeIndex.insert(token);
                if (!this.testedTokens.includesTested(token)) {
                    this.testIndex.insert(token);
                }
            }
            this.freeTokens.add(token, time, n);
            this.freeTokenCount += n;
            if (!alreadyRegistered) {
                this.reserve(token, n);
            }
            this.triggerables.proposeSearch();
            TokenEvent te = new TokenEvent(this, token);
            this.listeners.tokenAdded(te);
            this.place.getListenerSet().tokenAdded(te);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void untestToken(Object token) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.lock.lock();
        try {
            double time = this.testedTokens.removeTested(token);
            if (!this.testedTokens.includesTested(token)) {
                if (!this.freeTokens.includesAnytime(token)) {
                    this.freeIndex.insert(token);
                }
                this.freeTokens.add(token, time);
                ++this.freeTokenCount;
                --this.testedTokenCount;
                this.triggerables.proposeSearch();
                TokenEvent te = new TokenEvent(this, token);
                this.listeners.tokenUntested(te);
                this.place.getListenerSet().tokenUntested(te);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        RenewObjectOutputStream rOut = null;
        if (out instanceof RenewObjectOutputStream) {
            rOut = (RenewObjectOutputStream)out;
        }
        if (rOut != null) {
            rOut.beginDomain((Object)this);
        }
        out.defaultWriteObject();
        if (rOut != null) {
            rOut.delayedWriteObject((Object)this.freeTokens, (DelayedFieldOwner)this);
            rOut.delayedWriteObject((Object)this.testedTokens, (DelayedFieldOwner)this);
            rOut.endDomain((Object)this);
        } else {
            out.writeObject(this.freeTokens);
            out.writeObject(this.testedTokens);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        in.defaultReadObject();
        if (!(in instanceof RenewObjectInputStream)) {
            this.freeTokens = (TokenBag)in.readObject();
            this.testedTokens = (TestTokenBag)in.readObject();
            this.recomputeIndexes();
        }
    }

    @Override
    public void reassignField(Object value) throws IOException {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        if (!this.tryReassignField(value)) {
            if (value instanceof TokenBag) {
                this.freeTokens = (TokenBag)value;
            } else if (value instanceof TestTokenBag) {
                this.testedTokens = (TestTokenBag)value;
                this.recomputeIndexes();
            } else {
                throw new NotSerializableException("Value of unexpected type given to MultiSetPlaceInstance.reassignField():" + value.getClass().getName() + ".");
            }
        }
    }

    private void recomputeIndexes() {
        this.freeIndex = new TupleIndex();
        this.addToIndex(this.freeIndex, this.freeTokens.uniqueElements());
        this.testIndex = new TupleIndex();
        this.addToIndex(this.testIndex, this.freeTokens.uniqueElements());
        this.addToIndex(this.testIndex, this.testedTokens.uniqueElements());
    }

    private void addToIndex(TupleIndex index, Collection<Object> tokenList) {
        for (Object token : tokenList) {
            index.insert(token);
        }
    }

    protected void finalize() throws Throwable {
        for (Object token : this.testIndex.getAllElements()) {
            this.unreserve(token);
        }
        super.finalize();
    }
}

