/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net;

import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.net.NetInstance;
import de.renew.net.Place;
import de.renew.net.SimulatablePlaceInstance;
import de.renew.net.TimeSet;
import de.renew.net.event.TokenEvent;
import de.renew.unify.Impossible;
import de.renew.util.DelayedFieldOwner;
import de.renew.util.Queue;
import de.renew.util.RenewObjectInputStream;
import de.renew.util.RenewObjectOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.Set;
import java.util.Vector;

public class FIFOPlaceInstance
extends SimulatablePlaceInstance {
    static final long serialVersionUID = 5987006166655815747L;
    private int tokenTests;
    private transient Queue<Object> tokenQueue;

    FIFOPlaceInstance(NetInstance netInstance, Place place, boolean wantInitialTokens) throws Impossible {
        super(netInstance, place, wantInitialTokens);
    }

    @Override
    protected void initTokenStorage() {
        this.tokenQueue = new Queue();
        this.tokenTests = 0;
    }

    private Set<Object> getFrontSet() {
        return Collections.singleton(this.tokenQueue.front());
    }

    @Override
    public Set<Object> getDistinctTokens() {
        if (this.tokenTests == 0 && !this.tokenQueue.isEmpty()) {
            return this.getFrontSet();
        }
        return Collections.emptySet();
    }

    @Override
    public Set<Object> getDistinctTokens(Object pattern) {
        return this.getDistinctTokens();
    }

    @Override
    public Set<Object> getDistinctTestableTokens() {
        if (!this.tokenQueue.isEmpty()) {
            return this.getFrontSet();
        }
        return Collections.emptySet();
    }

    @Override
    public Set<Object> getDistinctTestableTokens(Object pattern) {
        return this.getDistinctTestableTokens();
    }

    @Override
    public int getNumberOfTokens() {
        return this.tokenQueue.isEmpty() ? 0 : 1;
    }

    @Override
    public int getNumberOfTestedTokens() {
        return this.tokenTests == 0 ? 0 : 1;
    }

    @Override
    boolean containsToken(Object token) {
        return this.containsTestableToken(token) && this.tokenTests == 0;
    }

    @Override
    public int getTokenCount(Object token) {
        return this.containsToken(token) ? 1 : 0;
    }

    @Override
    public TimeSet getFreeTimeSet(Object token) {
        if (this.containsToken(token)) {
            return TimeSet.ZERO;
        }
        return TimeSet.EMPTY;
    }

    @Override
    public double computeEarliestTime(Object token, TimeSet times) {
        return 0.0;
    }

    @Override
    public boolean containsTestedToken(Object token) {
        return this.containsTestableToken(token) && this.tokenTests > 0;
    }

    @Override
    public boolean containsTestableToken(Object token) {
        return this.tokenQueue.front().equals(token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double removeToken(Object token, double delay) throws Impossible {
        double removedTime;
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.lock.lock();
        try {
            removedTime = 0.0;
            if (!this.containsToken(token)) {
                throw new Impossible();
            }
            this.tokenQueue.dequeue();
            this.triggerables.proposeSearch();
            TokenEvent te = new TokenEvent(this, token);
            this.listeners.tokenRemoved(te);
            this.place.getListenerSet().tokenRemoved(te);
            this.unreserve(token);
        }
        finally {
            this.lock.unlock();
        }
        return removedTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double testToken(Object token) throws Impossible {
        double removedTime;
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.lock.lock();
        try {
            boolean wantNotify = false;
            removedTime = 0.0;
            if (this.containsToken(token)) {
                if (this.tokenTests == 0) {
                    wantNotify = true;
                }
                ++this.tokenTests;
            } else {
                throw new Impossible();
            }
            if (wantNotify) {
                this.triggerables.proposeSearch();
                TokenEvent te = new TokenEvent(this, token);
                this.listeners.tokenTested(te);
                this.place.getListenerSet().tokenTested(te);
            }
        }
        finally {
            this.lock.unlock();
        }
        return removedTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void extractAllTokens(Vector<Object> tokens, Vector<Double> timeStamps) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.lock.lock();
        try {
            if (this.tokenTests == 0) {
                while (!this.tokenQueue.isEmpty()) {
                    Object token = this.tokenQueue.dequeue();
                    if (tokens != null) {
                        tokens.addElement(token);
                    }
                    if (timeStamps == null) continue;
                    timeStamps.addElement(0.0);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void insertToken(Object token, double time) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.internallyInsertToken(token, time, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void internallyInsertToken(Object token, double time, boolean alreadyRegistered) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.lock.lock();
        try {
            this.tokenQueue.enqueue(token);
            if (!alreadyRegistered) {
                this.reserve(token);
            }
            this.triggerables.proposeSearch();
            TokenEvent te = new TokenEvent(this, token);
            this.listeners.tokenAdded(te);
            this.place.getListenerSet().tokenAdded(te);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void untestToken(Object token) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.lock.lock();
        try {
            if (this.containsTestedToken(token)) {
                --this.tokenTests;
                if (this.tokenTests == 0) {
                    this.triggerables.proposeSearch();
                    TokenEvent te = new TokenEvent(this, token);
                    this.listeners.tokenUntested(te);
                    this.place.getListenerSet().tokenUntested(te);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        RenewObjectOutputStream rOut = null;
        if (out instanceof RenewObjectOutputStream) {
            rOut = (RenewObjectOutputStream)out;
        }
        if (rOut != null) {
            rOut.beginDomain((Object)this);
        }
        out.defaultWriteObject();
        if (rOut != null) {
            rOut.delayedWriteObject(this.tokenQueue, (DelayedFieldOwner)this);
            rOut.endDomain((Object)this);
        } else {
            out.writeObject(this.tokenQueue);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        in.defaultReadObject();
        if (!(in instanceof RenewObjectInputStream)) {
            this.tokenQueue = (Queue)in.readObject();
        }
    }

    @Override
    public void reassignField(Object value) throws IOException {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        if (!this.tryReassignField(value)) {
            if (value instanceof Queue) {
                this.tokenQueue = (Queue)value;
            } else {
                throw new NotSerializableException("Value of unexpected type given to FIFOPlaceInstance.reassign():" + value.getClass().getName() + ".");
            }
        }
    }

    protected void finalize() throws Throwable {
        while (!this.tokenQueue.isEmpty()) {
            Object token = this.tokenQueue.dequeue();
            this.unreserve(token);
        }
        super.finalize();
    }
}

