/*
 * Decompiled with CFR 0.152.
 */
package de.renew.expression;

import de.renew.expression.Expression;
import de.renew.expression.ExpressionWithTypeField;
import de.renew.expression.Function;
import de.renew.expression.VariableMapper;
import de.renew.unify.CalculationChecker;
import de.renew.unify.Impossible;
import de.renew.unify.Notifiable;
import de.renew.unify.StateRecorder;
import de.renew.unify.Unify;
import de.renew.unify.Variable;
import de.renew.util.Types;

public class InvertibleExpression
extends ExpressionWithTypeField {
    Expression argument;
    Function forwardFunction;
    Function backwardFunction;

    public InvertibleExpression(Class<?> targetType, Expression argument, Function forwardFunction, Function backwardFunction) {
        super(targetType);
        this.argument = argument;
        this.forwardFunction = forwardFunction;
        this.backwardFunction = backwardFunction;
    }

    @Override
    public boolean isInvertible() {
        return this.argument.isInvertible();
    }

    public Expression getArgument() {
        return this.argument;
    }

    @Override
    public Object startEvaluation(VariableMapper mapper, StateRecorder recorder, CalculationChecker checker) throws Impossible {
        final Variable source = new Variable(this.argument.startEvaluation(mapper, recorder, checker), recorder);
        final Variable target = new Variable();
        if (checker != null) {
            checker.addEarlyVariable(source, recorder);
        }
        Notifiable sourceListener = new Notifiable(){

            @Override
            public void boundNotify(StateRecorder irecorder) throws Impossible {
                if (Unify.isBound(source)) {
                    Unify.unify(target, InvertibleExpression.this.forwardFunction.function(source.getValue()), irecorder);
                }
            }
        };
        source.addListener(sourceListener, recorder);
        Notifiable targetListener = new Notifiable(){

            @Override
            public void boundNotify(StateRecorder irecorder) throws Impossible {
                if (Unify.isBound(target)) {
                    Unify.unify(source, InvertibleExpression.this.backwardFunction.function(target.getValue()), irecorder);
                }
            }
        };
        target.addListener(targetListener, recorder);
        return target.getValue();
    }

    @Override
    public Object registerCalculation(VariableMapper mapper, StateRecorder recorder, CalculationChecker checker) throws Impossible {
        Variable source = new Variable(this.argument.registerCalculation(mapper, recorder, checker), recorder);
        Variable target = new Variable();
        checker.addLateVariable(source, recorder);
        checker.addCalculated(this.getType(), target, source.getValue(), recorder);
        return target.getValue();
    }

    public String toString() {
        return "InvertibleExpr(" + Types.typeToString((Class)this.getType()) + ": " + String.valueOf(this.forwardFunction) + ", " + String.valueOf(this.backwardFunction) + ", " + String.valueOf(this.argument) + ")";
    }
}

