/*
 * Decompiled with CFR 0.152.
 */
package de.renew.expression;

import de.renew.expression.Expression;
import de.renew.expression.Function;
import de.renew.expression.VariableMapper;
import de.renew.unify.CalculationChecker;
import de.renew.unify.Impossible;
import de.renew.unify.Notifiable;
import de.renew.unify.StateRecorder;
import de.renew.unify.Unify;
import de.renew.unify.Variable;
import de.renew.util.Types;
import de.renew.util.Value;

public class GuardExpression
implements Expression {
    Expression argument;
    Function function;

    public GuardExpression(Expression argument, Function function) {
        this.argument = argument;
        this.function = function;
    }

    @Override
    public boolean isInvertible() {
        return this.argument.isInvertible();
    }

    @Override
    public Class<?> getType() {
        return this.argument.getType();
    }

    public Expression getArgument() {
        return this.argument;
    }

    @Override
    public Object startEvaluation(VariableMapper mapper, StateRecorder recorder, CalculationChecker checker) throws Impossible {
        final Variable source = new Variable(this.argument.startEvaluation(mapper, recorder, checker), recorder);
        if (checker != null) {
            checker.addEarlyVariable(source, recorder);
        }
        Notifiable sourceListener = new Notifiable(){

            @Override
            public void boundNotify(StateRecorder irecorder) throws Impossible {
                if (Unify.isBound(source)) {
                    Object result = GuardExpression.this.function.function(source.getValue());
                    if (result instanceof Value) {
                        result = ((Value)result).value;
                    }
                    if (!Boolean.TRUE.equals(result)) {
                        throw new Impossible();
                    }
                }
            }
        };
        source.addListener(sourceListener, recorder);
        return source.getValue();
    }

    @Override
    public Object registerCalculation(VariableMapper mapper, StateRecorder recorder, CalculationChecker checker) throws Impossible {
        return this.argument.registerCalculation(mapper, recorder, checker);
    }

    public String toString() {
        return "GuardExpr(" + Types.typeToString(this.getType()) + ": " + String.valueOf(this.function) + ", " + String.valueOf(this.argument) + ")";
    }
}

