/*
 * Decompiled with CFR 0.152.
 */
package de.renew.expression;

import de.renew.expression.Expression;
import de.renew.expression.ExpressionWithTypeField;
import de.renew.expression.VariableMapper;
import de.renew.unify.CalculationChecker;
import de.renew.unify.Impossible;
import de.renew.unify.StateRecorder;
import de.renew.unify.Unify;
import de.renew.unify.Variable;
import de.renew.util.Types;

public class EqualsExpression
extends ExpressionWithTypeField {
    Expression left;
    Expression right;

    public EqualsExpression(Class<?> targetType, Expression left, Expression right) {
        super(targetType);
        this.left = left;
        this.right = right;
    }

    @Override
    public boolean isInvertible() {
        return true;
    }

    public Expression getLeft() {
        return this.left;
    }

    public Expression getRight() {
        return this.right;
    }

    @Override
    public Object startEvaluation(VariableMapper mapper, StateRecorder recorder, CalculationChecker checker) throws Impossible {
        Variable result = new Variable(this.left.startEvaluation(mapper, recorder, checker), recorder);
        Object rightResult = this.right.startEvaluation(mapper, recorder, checker);
        Unify.unify(result, rightResult, recorder);
        return result.getValue();
    }

    @Override
    public Object registerCalculation(VariableMapper mapper, StateRecorder recorder, CalculationChecker checker) throws Impossible {
        Variable result = new Variable(this.left.registerCalculation(mapper, recorder, checker), recorder);
        Object rightObject = this.right.registerCalculation(mapper, recorder, checker);
        checker.addCalculated(this.getType(), result.getValue(), rightObject, recorder);
        return result.getValue();
    }

    public String toString() {
        return "EqualsExpr(" + Types.typeToString((Class)this.getType()) + ": " + String.valueOf(this.left) + " = " + String.valueOf(this.right) + ")";
    }
}

