/*
 * Decompiled with CFR 0.152.
 */
package de.renew.expression;

import de.renew.expression.Expression;
import de.renew.expression.ExpressionWithTypeField;
import de.renew.expression.Function;
import de.renew.expression.VariableMapper;
import de.renew.unify.CalculationChecker;
import de.renew.unify.Impossible;
import de.renew.unify.Notifiable;
import de.renew.unify.StateRecorder;
import de.renew.unify.Unify;
import de.renew.unify.Variable;
import de.renew.util.Types;

public class CallExpression
extends ExpressionWithTypeField {
    Expression argument;
    Function function;

    public CallExpression(Class<?> targetType, Expression argument, Function function) {
        super(targetType);
        this.argument = argument;
        this.function = function;
    }

    @Override
    public boolean isInvertible() {
        return false;
    }

    public Expression getArgument() {
        return this.argument;
    }

    @Override
    public Object startEvaluation(VariableMapper mapper, StateRecorder recorder, CalculationChecker checker) throws Impossible {
        Variable source = new Variable(this.argument.startEvaluation(mapper, recorder, checker), recorder);
        Variable target = new Variable();
        if (checker != null) {
            checker.addEarlyVariable(source, recorder);
        }
        CallExpression.expressionConstraint(target, this.function, source, recorder);
        return target.getValue();
    }

    @Override
    public Object registerCalculation(VariableMapper mapper, StateRecorder recorder, CalculationChecker checker) throws Impossible {
        Variable source = new Variable(this.argument.registerCalculation(mapper, recorder, checker), recorder);
        Variable target = new Variable();
        checker.addLateVariable(source, recorder);
        checker.addCalculated(this.getType(), target, source.getValue(), recorder);
        return target.getValue();
    }

    public static void expressionConstraint(final Variable target, final Function function, final Variable source, StateRecorder recorder) throws Impossible {
        Notifiable listener = new Notifiable(){

            @Override
            public void boundNotify(StateRecorder irecorder) throws Impossible {
                if (Unify.isBound(source)) {
                    Unify.unify(target, function.function(source.getValue()), irecorder);
                }
            }
        };
        source.addListener(listener, recorder);
    }

    public String toString() {
        return "CallExpr(" + Types.typeToString((Class)this.getType()) + ": " + String.valueOf(this.function) + ", " + String.valueOf(this.argument) + ")";
    }
}

