/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.simulator;

import de.renew.engine.searcher.Finder;
import de.renew.engine.searcher.Searchable;
import de.renew.engine.searcher.Searcher;
import de.renew.engine.searchqueue.SearchQueue;
import de.renew.engine.simulator.SimulationThreadPool;

public class OverallEarliestTimeFinder
implements Finder {
    private final Finder _finder;
    private double _overallEarliestTime = Double.POSITIVE_INFINITY;

    public OverallEarliestTimeFinder(Finder finder) {
        this._finder = finder;
    }

    @Override
    public void found(Searcher searcher) {
        double currentTime;
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        double possibleTime = searcher.getEarliestTime();
        if (possibleTime < (currentTime = SearchQueue.getTime())) {
            possibleTime = currentTime;
        }
        if (possibleTime < this._overallEarliestTime) {
            this._overallEarliestTime = possibleTime;
        }
        if (possibleTime == currentTime) {
            this._finder.found(searcher);
        }
    }

    @Override
    public boolean isCompleted() {
        return this._finder.isCompleted();
    }

    public double getOverallEarliestTime() {
        return this._overallEarliestTime;
    }

    public void insertIntoSearchQueue(Searchable searchable) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        if (this._overallEarliestTime < Double.POSITIVE_INFINITY) {
            SearchQueue.include(searchable, this._overallEarliestTime);
        }
    }
}

