/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.simulator;

import de.renew.engine.simulator.SimulationThread;
import de.renew.util.Semaphor;

class BlockingSimulationRunnable
implements Runnable {
    private final Runnable _task;
    private final Semaphor _lock;
    private Thread _ancestor;

    public BlockingSimulationRunnable(Runnable task, Semaphor lock, Thread ancestor) {
        this._task = task;
        this._lock = lock;
        this._ancestor = ancestor;
    }

    public Thread getAncestor() {
        return this._ancestor;
    }

    @Override
    public void run() {
        try {
            this._task.run();
        }
        finally {
            this.abort((SimulationThread)Thread.currentThread());
        }
    }

    protected void abort(SimulationThread t) {
        this._lock.V();
        this._ancestor = null;
        if (t != null) {
            t.setAncestor(null);
        }
    }
}

