/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.simulator;

import de.renew.database.TransactionSource;
import de.renew.engine.common.StepIdentifier;
import de.renew.engine.searcher.Searchable;
import de.renew.engine.searcher.Searcher;
import de.renew.engine.searchqueue.SearchQueue;
import de.renew.engine.searchqueue.SearchQueueListener;
import de.renew.engine.simulator.AbortFinder;
import de.renew.engine.simulator.ExecuteFinder;
import de.renew.engine.simulator.OverallEarliestTimeFinder;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.engine.simulator.Simulator;
import de.renew.engine.simulator.SimulatorEventQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class AbstractConcurrentSimulator
implements Runnable,
Simulator,
SearchQueueListener {
    private static final Logger LOGGER = Logger.getLogger(AbstractConcurrentSimulator.class);
    private static long _runCounter = 0L;
    private final long _simulationRunId;
    private final Searcher _searcher = new Searcher();
    private static final Lock LOCK = new ReentrantLock();
    private final boolean _wantConcurrentExecution;
    private final boolean _wantEventQueueDelay;
    private ExecuteFinder _executeFinder;
    private AbortFinder _abortFinder;
    private long _cycle = 0L;
    private SimulationMode _desiredSimulationMode = SimulationMode.STOP;
    private boolean _idle = true;
    private int _stepStatusCode = 0;
    private boolean _searchQueueIsEmpty = false;
    private boolean _alreadyRegistered = false;
    private final Object _threadLock = new Object();

    public AbstractConcurrentSimulator(boolean wantEventQueueDelay, boolean wantConcurrentExecution) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this._wantEventQueueDelay = wantEventQueueDelay;
        this._wantConcurrentExecution = wantConcurrentExecution;
        this._simulationRunId = ((long)this.getClass().getName().hashCode() << 32) + _runCounter++;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(this.getClass().getSimpleName() + ": Starting run with id " + this._simulationRunId));
        }
        this.setupFinders();
        SimulationThreadPool.getCurrent().execute(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupFinders() {
        Object object = this._threadLock;
        synchronized (object) {
            this._executeFinder = new ExecuteFinder();
            this._abortFinder = new AbortFinder(this._executeFinder);
        }
    }

    @Override
    public boolean isActive() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void searchQueueNonempty() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        Object object = this._threadLock;
        synchronized (object) {
            this._searchQueueIsEmpty = false;
            this._alreadyRegistered = false;
            this._threadLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerAtSearchQueue() {
        Class<SearchQueue> clazz = SearchQueue.class;
        synchronized (SearchQueue.class) {
            Object object = this._threadLock;
            synchronized (object) {
                this._searchQueueIsEmpty = SearchQueue.isTotallyEmpty();
                if (this._searchQueueIsEmpty && !this._alreadyRegistered) {
                    SearchQueue.insertListener(this);
                    this._alreadyRegistered = true;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void terminateRun() {
        SimulationThreadPool.getCurrent().executeAndWait(() -> {
            this.requestMode(SimulationMode.TERMINATE);
            try {
                TransactionSource.simulationStateChanged(false, false);
            }
            catch (Exception e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        });
    }

    @Override
    public void stopRun() {
        SimulationThreadPool.getCurrent().executeAndWait(() -> {
            this.requestMode(SimulationMode.STOP);
            try {
                TransactionSource.simulationStateChanged(true, false);
            }
            catch (Exception e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        });
    }

    @Override
    public int step() {
        Future<Integer> future = SimulationThreadPool.getCurrent().submitAndWait(() -> {
            LOCK.lock();
            this.requestMode(SimulationMode.STEP);
            try {
                TransactionSource.simulationStateChanged(true, false);
            }
            catch (Exception e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                LOCK.unlock();
            }
            return this._stepStatusCode;
        });
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)e);
        }
        catch (ExecutionException e) {
            LOGGER.error((Object)"Simulation thread threw an exception", (Throwable)e);
        }
        return -1;
    }

    @Override
    public void startRun() {
        SimulationThreadPool.getCurrent().execute(() -> {
            this.requestMode(SimulationMode.RUN);
            try {
                TransactionSource.simulationStateChanged(true, true);
            }
            catch (Exception e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestMode(SimulationMode simulationMode) {
        Object object = this._threadLock;
        synchronized (object) {
            if (this._desiredSimulationMode.isGreaterThan(SimulationMode.TERMINATE)) {
                this._desiredSimulationMode = simulationMode;
                if (simulationMode.isGreaterThan(SimulationMode.STOP)) {
                    this._idle = false;
                } else {
                    this._abortFinder.abortSearch();
                }
                this._threadLock.notifyAll();
            }
            if (SimulationMode.RUN.isGreaterThan(simulationMode) && SimulationMode.RUN.isGreaterThan(this._desiredSimulationMode)) {
                while (!this._idle) {
                    try {
                        this._threadLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object;
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        while (this._desiredSimulationMode.isGreaterOrEqualTo(SimulationMode.STOP)) {
            Searchable searchable;
            object = this._threadLock;
            synchronized (object) {
                while (this._searchQueueIsEmpty && this._desiredSimulationMode == SimulationMode.RUN) {
                    try {
                        this._threadLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this._stepStatusCode = 0;
            while (this._desiredSimulationMode.isGreaterThan(SimulationMode.STOP) && (searchable = SearchQueue.extract()) != null) {
                this.setupFinders();
                if (!this._desiredSimulationMode.isGreaterThan(SimulationMode.STOP)) continue;
                OverallEarliestTimeFinder timeFinder = new OverallEarliestTimeFinder(this._abortFinder);
                this._searcher.searchAndRecover(timeFinder, searchable, searchable);
                Thread.yield();
                if (this._abortFinder.isCompleted()) {
                    SearchQueue.includeNow(searchable);
                } else {
                    timeFinder.insertIntoSearchQueue(searchable);
                }
                if (!this._executeFinder.isCompleted()) continue;
                if (this._wantEventQueueDelay) {
                    SimulatorEventQueue.awaitEmptyQueue();
                }
                this._executeFinder.execute(this.nextStepIdentifier(), this._wantConcurrentExecution);
                this.setupFinders();
                this._stepStatusCode = 1;
                Object object2 = this._threadLock;
                synchronized (object2) {
                    if (this._desiredSimulationMode == SimulationMode.STEP) {
                        this._desiredSimulationMode = SimulationMode.STOP;
                    }
                }
            }
            this.registerAtSearchQueue();
            object = this._threadLock;
            synchronized (object) {
                if (this._desiredSimulationMode == SimulationMode.STEP) {
                    this._desiredSimulationMode = SimulationMode.STOP;
                    this._stepStatusCode = 3;
                }
                if (SimulationMode.STOP.isGreaterOrEqualTo(this._desiredSimulationMode)) {
                    this._idle = true;
                    this._threadLock.notifyAll();
                }
                while (this._desiredSimulationMode == SimulationMode.STOP) {
                    try {
                        this._threadLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        object = this._threadLock;
        synchronized (object) {
            if (!this._idle) {
                this._idle = true;
                this._threadLock.notifyAll();
            }
        }
    }

    @Override
    public void refresh() {
    }

    @Override
    public boolean isSequential() {
        return !this._wantConcurrentExecution;
    }

    @Override
    public StepIdentifier nextStepIdentifier() {
        Future<StepIdentifier> future = SimulationThreadPool.getCurrent().submitAndWait(() -> new StepIdentifier(this._simulationRunId, new long[]{++this._cycle}));
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)e);
        }
        catch (ExecutionException e) {
            LOGGER.error((Object)"Simulation thread threw an exception", (Throwable)e);
        }
        return null;
    }

    @Override
    public StepIdentifier currentStepIdentifier() {
        Future<StepIdentifier> future = SimulationThreadPool.getCurrent().submitAndWait(() -> new StepIdentifier(this._simulationRunId, new long[]{this._cycle}));
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)e);
        }
        catch (ExecutionException e) {
            LOGGER.error((Object)"Simulation thread threw an exception", (Throwable)e);
        }
        return null;
    }

    @Override
    public long[] collectSimulationRunIds() {
        return new long[]{this._simulationRunId};
    }

    private static enum SimulationMode {
        TERMINATE(-1),
        STOP(0),
        STEP(1),
        RUN(2);

        private final int _value;

        private SimulationMode(int value) {
            this._value = value;
        }

        public int getValue() {
            return this._value;
        }

        public boolean isGreaterThan(SimulationMode other) {
            return this._value > other._value;
        }

        public boolean isGreaterOrEqualTo(SimulationMode other) {
            return this._value >= other._value;
        }
    }
}

