/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.searchqueue;

import de.renew.engine.searcher.Searchable;
import de.renew.engine.searchqueue.RandomQueueNode;
import de.renew.engine.searchqueue.SearchQueueData;
import de.renew.engine.simulator.SimulationThreadPool;
import java.util.Enumeration;
import java.util.Hashtable;

class RandomSearchQueue
implements SearchQueueData {
    private final double time;
    private RandomQueueNode[] elements;
    private int size;
    private final Hashtable<Searchable, RandomQueueNode> lookup;

    RandomSearchQueue(double time) {
        this.time = time;
        this.elements = new RandomQueueNode[8];
        this.lookup = new Hashtable();
        this.size = 0;
    }

    @Override
    public double getTime() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        return this.time;
    }

    private void setCapacity(int capacity) {
        RandomQueueNode[] newElements = new RandomQueueNode[capacity];
        System.arraycopy(this.elements, 0, newElements, 0, this.size);
        this.elements = newElements;
    }

    private void ensureCapacity(int capacity) {
        if (capacity > this.elements.length) {
            if (capacity < 2 * this.elements.length) {
                capacity = 2 * this.elements.length;
            }
            this.setCapacity(capacity);
        }
    }

    private void limitCapacity() {
        if (this.size >= 8 && this.size * 4 < this.elements.length) {
            this.setCapacity(this.size * 2);
        }
    }

    @Override
    public void include(Searchable searchable) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        if (!this.lookup.containsKey(searchable)) {
            RandomQueueNode node;
            this.ensureCapacity(this.size + 1);
            this.elements[this.size] = node = new RandomQueueNode(this.size, searchable);
            ++this.size;
            this.lookup.put(searchable, node);
        }
    }

    private void discard(RandomQueueNode node) {
        int pos = node.pos;
        this.elements[pos] = this.elements[this.size - 1];
        this.elements[pos].pos = pos;
        this.elements[this.size - 1] = null;
        --this.size;
        this.limitCapacity();
        this.lookup.remove(node.searchable);
    }

    @Override
    public void exclude(Searchable searchable) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        RandomQueueNode node = this.lookup.get(searchable);
        if (node != null) {
            this.discard(node);
        }
    }

    @Override
    public Searchable extract() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        if (this.size == 0) {
            return null;
        }
        int pos = (int)(Math.random() * (double)this.size);
        if (pos >= this.size) {
            pos = this.size - 1;
        }
        RandomQueueNode node = this.elements[pos];
        this.discard(node);
        return node.searchable;
    }

    @Override
    public Enumeration<Searchable> elements() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        return this.lookup.keys();
    }

    @Override
    public int size() {
        return this.size;
    }
}

