/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.searchqueue;

import de.renew.engine.searcher.Searchable;
import de.renew.engine.searchqueue.DSQEnumeration;
import de.renew.engine.searchqueue.DSQListNode;
import de.renew.engine.searchqueue.SearchQueueData;
import de.renew.engine.simulator.SimulationThreadPool;
import java.util.Enumeration;
import java.util.Hashtable;

class DeterministicSearchQueue
implements SearchQueueData {
    private final double time;
    private DSQListNode list;
    private final Hashtable<Searchable, DSQListNode> lookup;
    private int size = 0;

    DeterministicSearchQueue(double time) {
        this.time = time;
        this.list = null;
        this.lookup = new Hashtable();
    }

    @Override
    public double getTime() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        return this.time;
    }

    @Override
    public void include(Searchable searchable) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        DSQListNode node = this.lookup.get(searchable);
        if (node == null) {
            ++this.size;
            node = new DSQListNode(searchable);
            this.lookup.put(searchable, node);
            if (this.list == null) {
                this.list = node;
            } else {
                node.prev = this.list.prev;
                node.next = this.list;
                this.list.prev.next = node;
                this.list.prev = node;
            }
        }
    }

    private void discard(DSQListNode node) {
        --this.size;
        this.lookup.remove(node.elem);
        if (node == node.next) {
            this.list = null;
        } else {
            node.next.prev = node.prev;
            node.prev.next = node.next;
            if (this.list == node) {
                this.list = node.next;
            }
        }
    }

    @Override
    public void exclude(Searchable searchable) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        DSQListNode node = this.lookup.get(searchable);
        if (node != null) {
            this.discard(node);
        }
    }

    @Override
    public Searchable extract() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        if (this.list == null) {
            return null;
        }
        Searchable result = this.list.elem;
        this.discard(this.list);
        return result;
    }

    @Override
    public Enumeration<Searchable> elements() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        return new DSQEnumeration(this.list);
    }

    @Override
    public int size() {
        return this.size;
    }
}

