/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.searcher;

import de.renew.engine.searcher.TriggerCollection;
import de.renew.engine.searcher.Triggerable;
import de.renew.engine.searcher.TriggerableCollection;
import de.renew.engine.simulator.SimulationThreadPool;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class TriggerCollectionImpl
implements Serializable,
TriggerCollection {
    private final Set<TriggerableCollection> triggers;
    private final Triggerable triggerable;

    public TriggerCollectionImpl(Triggerable triggerable) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.triggers = new HashSet<TriggerableCollection>();
        this.triggerable = triggerable;
    }

    @Override
    public void include(TriggerableCollection trigger) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.triggers.add(trigger);
    }

    @Override
    public void exclude(TriggerableCollection trigger) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.triggers.remove(trigger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        ArrayList<TriggerableCollection> list;
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        TriggerCollectionImpl triggerCollectionImpl = this;
        synchronized (triggerCollectionImpl) {
            list = new ArrayList<TriggerableCollection>(this.triggers);
        }
        for (TriggerableCollection triggerables : list) {
            triggerables.exclude(this.triggerable);
        }
    }
}

