/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.searcher;

import de.renew.engine.searcher.Binder;
import de.renew.engine.searcher.ChannelBinder;
import de.renew.engine.searcher.ChannelTarget;
import de.renew.engine.searcher.DeltaSet;
import de.renew.engine.searcher.DeltaSetFactory;
import de.renew.engine.searcher.Finder;
import de.renew.engine.searcher.ISearcher;
import de.renew.engine.searcher.Occurrence;
import de.renew.engine.searcher.Searchable;
import de.renew.engine.searcher.Triggerable;
import de.renew.engine.searcher.TriggerableCollection;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.unify.CalculationChecker;
import de.renew.unify.Impossible;
import de.renew.unify.StateRecorder;
import de.renew.unify.Variable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class Searcher
implements ISearcher {
    public static final Logger logger = Logger.getLogger(Searcher.class);
    private Finder finder;
    private final Set<Binder> binders;
    private final Set<Occurrence> occurrences;
    private Triggerable primaryTriggerable;
    private double earliestTime;
    @Deprecated
    public CalculationChecker calcChecker;
    @Deprecated
    public StateRecorder recorder;
    private final Map<String, DeltaSet> deltaSets;

    public Searcher() {
        this(new HashSet<Occurrence>(), new HashMap<String, DeltaSet>());
    }

    protected Searcher(Triggerable primaryTriggerable, Finder finder) {
        this();
        this.primaryTriggerable = primaryTriggerable;
        this.finder = finder;
    }

    protected Searcher(Searcher parent, Finder finder) {
        this(parent.occurrences, parent.deltaSets);
        this.primaryTriggerable = parent.primaryTriggerable;
        this.finder = finder;
    }

    private Searcher(Set<Occurrence> occurrences, Map<String, DeltaSet> deltaSets) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.binders = new HashSet<Binder>();
        this.occurrences = occurrences;
        this.calcChecker = new CalculationChecker();
        this.recorder = new StateRecorder();
        this.deltaSets = deltaSets;
    }

    @Override
    public CalculationChecker getCalculationChecker() {
        return this.calcChecker;
    }

    @Override
    public StateRecorder getStateRecorder() {
        return this.recorder;
    }

    @Override
    public boolean isCompleted() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        return this.finder.isCompleted();
    }

    private void setPrimaryTriggerable(Triggerable triggerable) {
        if (triggerable != null) {
            triggerable.triggers().clear();
        }
        this.primaryTriggerable = triggerable;
    }

    protected Triggerable getPrimaryTriggerable() {
        return this.primaryTriggerable;
    }

    @Override
    public void insertTriggerable(TriggerableCollection triggerables) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        if (this.primaryTriggerable != null) {
            triggerables.include(this.primaryTriggerable);
        }
    }

    @Override
    public void addOccurrence(Occurrence occurrence) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.occurrences.add(occurrence);
    }

    @Override
    public void removeOccurrence(Occurrence occurrence) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.occurrences.remove(occurrence);
    }

    @Override
    public Collection<Occurrence> getOccurrences() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        return this.occurrences;
    }

    @Override
    public DeltaSet getDeltaSet(DeltaSetFactory factory) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        String category = factory.getCategory();
        DeltaSet result = this.deltaSets.get(category);
        if (result == null) {
            result = factory.createDeltaSet();
            this.deltaSets.put(category, result);
        }
        return result;
    }

    @Override
    public double getEarliestTime() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        return this.earliestTime;
    }

    private void setEarliestTime(double time) {
        this.earliestTime = time;
    }

    private Binder selectBestBinder() {
        Binder bestBinder = null;
        int bestBadness = 10000;
        Iterator<Binder> enumeration = this.binders.iterator();
        while (enumeration.hasNext() && !this.isCompleted()) {
            Binder binder = enumeration.next();
            int badness = binder.bindingBadness(this);
            if (badness >= bestBadness) continue;
            bestBinder = binder;
            bestBadness = badness;
        }
        return bestBinder;
    }

    @Override
    public void search() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        int checkpoint = this.recorder.checkpoint();
        if (!this.binders.isEmpty()) {
            Binder binder = this.selectBestBinder();
            if (binder != null && !this.isCompleted()) {
                this.removeBinder(binder);
                binder.bind(this);
                this.addBinder(binder);
            }
        } else if (this.calcChecker.isConsistent()) {
            double time = 0.0;
            for (DeltaSet deltaSet : this.deltaSets.values()) {
                time = Math.max(time, deltaSet.computeEarliestTime());
            }
            this.setEarliestTime(time);
            this.finder.found(this);
        }
        this.recorder.restore(checkpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void search(Occurrence occurrence) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        int checkpoint = this.recorder.checkpoint();
        try {
            Collection<Binder> binders = occurrence.makeBinders(this);
            this.addOccurrence(occurrence);
            this.addBinders(binders);
            this.search();
            this.removeBinders(binders);
            this.removeOccurrence(occurrence);
        }
        catch (Impossible impossible) {
        }
        finally {
            this.recorder.restore(checkpoint);
        }
    }

    @Override
    public void addBinder(Binder binder) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.binders.add(binder);
    }

    @Override
    public void removeBinder(Binder binder) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.binders.remove(binder);
    }

    @Override
    public void addBinders(Collection<Binder> binders) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.binders.addAll(binders);
    }

    @Override
    public void removeBinders(Collection<Binder> binders) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.binders.removeAll(binders);
    }

    private void startSearch() {
        this.recorder.restore();
        if (!this.occurrences.isEmpty() || !this.binders.isEmpty()) {
            throw new RuntimeException("Searcher was not in idle state at the start of a search.");
        }
    }

    @Override
    public void searchAndRecover(Finder finder, Searchable searchable, Triggerable triggerable) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.startSearch();
        this.finder = finder;
        this.setPrimaryTriggerable(triggerable);
        this.earliestTime = 0.0;
        try {
            searchable.startSearch(this);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        this.binders.clear();
        this.occurrences.clear();
        this.calcChecker.reset();
        this.recorder.restore();
        this.deltaSets.clear();
        this.setPrimaryTriggerable(null);
        this.finder = null;
    }

    @Override
    public void initiatedSearch(ChannelTarget channelTarget, String name, Variable params, boolean isOptional, Finder finder, Triggerable triggerable) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.startSearch();
        this.finder = finder;
        this.setPrimaryTriggerable(triggerable);
        try {
            Variable targetVariable = new Variable(channelTarget, this.recorder);
            ChannelBinder initialBinder = new ChannelBinder(targetVariable, name, params, isOptional);
            this.addBinder(initialBinder);
            this.search();
            this.removeBinder(initialBinder);
            this.recorder.restore();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        this.binders.clear();
        this.occurrences.clear();
        this.calcChecker.reset();
        this.recorder.restore();
        this.deltaSets.clear();
        this.setPrimaryTriggerable(null);
        this.finder = null;
    }
}

