/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.searcher;

import de.renew.engine.searcher.Binder;
import de.renew.engine.searcher.BindingBadness;
import de.renew.engine.searcher.ChannelTarget;
import de.renew.engine.searcher.Searcher;
import de.renew.engine.searcher.UplinkProvider;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.unify.Variable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class ChannelBinder
implements Binder {
    private final Variable targetVariable;
    private final String name;
    private final Variable params;
    private final boolean isOptional;

    public ChannelBinder(Variable targetVariable, String name, Variable params, boolean isOptional) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.targetVariable = targetVariable;
        this.name = name;
        this.params = params;
        this.isOptional = isOptional;
    }

    @Override
    public int bindingBadness(Searcher searcher) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        Object value = this.targetVariable.getValue();
        if (value instanceof ChannelTarget) {
            ChannelTarget channelTarget = (ChannelTarget)value;
            Collection<UplinkProvider> uplinkProviders = channelTarget.getUplinkProviders(this.name);
            return BindingBadness.clip(uplinkProviders.size());
        }
        return 10000;
    }

    @Override
    public void bind(Searcher searcher) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        ChannelTarget channelTarget = (ChannelTarget)this.targetVariable.getValue();
        ArrayList<UplinkProvider> providers = new ArrayList<UplinkProvider>(channelTarget.getUplinkProviders(this.name));
        Collections.shuffle(providers);
        Iterator uplinkProviders = providers.iterator();
        if (this.isOptional && !uplinkProviders.hasNext()) {
            searcher.search();
        } else {
            while (uplinkProviders.hasNext() && !searcher.isCompleted()) {
                UplinkProvider uplinkProvider = (UplinkProvider)uplinkProviders.next();
                uplinkProvider.bindChannel(this.params, searcher);
            }
        }
    }
}

