/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.common;

import de.renew.engine.common.SimulatorEvent;
import de.renew.engine.common.StepIdentifier;
import de.renew.engine.events.SimulationEvent;
import de.renew.engine.events.TraceEvent;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.net.NetInstance;
import de.renew.net.PlaceInstance;
import de.renew.net.TransitionInstance;
import org.apache.log4j.Logger;

public class SimulatorEventLogger {
    public static final String SIM_LOG_PREFIX = "simulation";

    public static void log(SimulatorEvent trace) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        SimulatorEventLogger.getLogger(trace).debug((Object)trace);
    }

    public static void log(SimulationEvent logObject) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        try {
            SimulatorEventLogger.log(new SimulatorEvent(logObject));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void log(StepIdentifier stepIdentifier, SimulationEvent logObject) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        SimulatorEventLogger.log(new SimulatorEvent(stepIdentifier, logObject));
    }

    public static void log(StepIdentifier stepIdentifier, SimulationEvent logObject, PlaceInstance pInstance) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        SimulatorEventLogger.log(new SimulatorEvent(stepIdentifier, logObject, pInstance));
    }

    public static void log(StepIdentifier stepIdentifier, SimulationEvent logObject, TransitionInstance tInstance) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        SimulatorEventLogger.log(new SimulatorEvent(stepIdentifier, logObject, tInstance));
    }

    public static void log(StepIdentifier stepIdentifier, SimulationEvent logObject, NetInstance nInstance) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        SimulatorEventLogger.log(new SimulatorEvent(stepIdentifier, logObject, nInstance));
    }

    public static void log(String logObject) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        try {
            SimulatorEventLogger.log(new SimulatorEvent(new TraceEvent(logObject)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void log(StepIdentifier stepIdentifier, String logObject) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        SimulatorEventLogger.log(new SimulatorEvent(stepIdentifier, new TraceEvent(logObject)));
    }

    public static void log(StepIdentifier stepIdentifier, String logObject, PlaceInstance pInstance) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        SimulatorEventLogger.log(new SimulatorEvent(stepIdentifier, (SimulationEvent)new TraceEvent(logObject), pInstance));
    }

    public static void log(StepIdentifier stepIdentifier, String logObject, TransitionInstance tInstance) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        SimulatorEventLogger.log(new SimulatorEvent(stepIdentifier, (SimulationEvent)new TraceEvent(logObject), tInstance));
    }

    public static void log(StepIdentifier stepIdentifier, String logObject, NetInstance nInstance) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        SimulatorEventLogger.log(new SimulatorEvent(stepIdentifier, (SimulationEvent)new TraceEvent(logObject), nInstance));
    }

    private static Logger getLogger(SimulatorEvent trace) {
        StringBuilder loggerName = new StringBuilder(SIM_LOG_PREFIX);
        if (trace.getNetInstance() != null) {
            loggerName.append(".");
            loggerName.append(trace.getNetInstance().getNet().getName());
            if (trace.getNetElementInstance() != null) {
                Object element = trace.getNetElementInstance();
                if (element instanceof TransitionInstance) {
                    loggerName.append(".");
                    loggerName.append(((TransitionInstance)element).getTransition().toString());
                } else if (element instanceof PlaceInstance) {
                    loggerName.append(".");
                    loggerName.append(((PlaceInstance)element).getPlace().toString());
                }
            }
        }
        return Logger.getLogger((String)loggerName.toString());
    }
}

