/*
 * Decompiled with CFR 0.152.
 */
package de.renew.database.entitylayer;

import de.renew.database.entitylayer.Attribute;
import de.renew.database.entitylayer.Entity;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;

public class SQLDialect {
    protected String convertStringForDB(String string) {
        int pos = ((String)string).indexOf("\\");
        while (pos >= 0) {
            string = ((String)string).substring(0, pos) + "\\\\" + ((String)string).substring(pos + 1);
            pos = ((String)string).indexOf("\\", pos + 2);
        }
        pos = ((String)string).indexOf("'");
        while (pos >= 0) {
            string = ((String)string).substring(0, pos) + "\\'" + ((String)string).substring(pos + 1);
            pos = ((String)string).indexOf("'", pos + 2);
        }
        return string;
    }

    protected String getDeleteString(String tableName, Attribute[] primaryKey, Object[] primaryKeyValue) {
        return this.getDeleteString(tableName, this.getStringOfAndedAttributesAndValues(primaryKey, primaryKeyValue));
    }

    protected String getDeleteString(String tableName, String condition) {
        StringBuffer delete = new StringBuffer();
        delete.append("delete from ");
        delete.append(tableName);
        if (!condition.equals("")) {
            delete.append(" where ");
            delete.append(condition);
        }
        return delete.toString();
    }

    protected String getInsertString(String tableName, Attribute[] attributes, Hashtable<String, Object> values, Attribute[] primaryKey) {
        StringBuffer update = new StringBuffer();
        update.append("insert into ");
        update.append(tableName);
        update.append(" (");
        update.append(this.getStringOfAttributes(attributes));
        update.append(") values (");
        update.append(this.getStringOfValues(attributes, values));
        update.append(")");
        return update.toString();
    }

    protected String getSelectString(String tableName, Attribute[] attributes) {
        return this.getSelectString(tableName, attributes, null, null);
    }

    protected String getSelectString(String tableName, Attribute[] attributes, String condition) {
        return this.getSelectString(tableName, attributes, condition, null);
    }

    protected String getSelectString(String tableName, Attribute[] attributes, String condition, String order) {
        StringBuffer query = new StringBuffer();
        query.append("select ");
        query.append(this.getStringOfAttributes(attributes));
        query.append(" from ");
        query.append(tableName);
        if (condition != null && !condition.equals("")) {
            query.append(" where ");
            query.append(condition);
        }
        if (order != null && !order.equals("")) {
            query.append(" order by ");
            query.append(order);
        }
        return query.toString();
    }

    protected String getSelectStringWithPrimaryKey(String tableName, Attribute[] attributes, Attribute[] primaryKey, Object[] primaryKeyValue) {
        return this.getSelectString(tableName, attributes, this.getStringOfAndedAttributesAndValues(primaryKey, primaryKeyValue));
    }

    protected String getStringOfAndedAttributesAndValues(Attribute[] attributes, Hashtable<String, Object> values) {
        StringBuffer result = new StringBuffer();
        for (int attributeNumber = 0; attributeNumber < attributes.length; ++attributeNumber) {
            if (attributeNumber > 0) {
                result.append(" and ");
            }
            result.append(this.getStringOfAttributeAndValue(attributes[attributeNumber], values.get(attributes[attributeNumber].getName())));
        }
        return result.toString();
    }

    protected String getStringOfAndedAttributesAndValues(Attribute[] attributes, Object[] values) {
        StringBuffer result = new StringBuffer();
        for (int attributeNumber = 0; attributeNumber < attributes.length; ++attributeNumber) {
            if (attributeNumber > 0) {
                result.append(" and ");
            }
            result.append(this.getStringOfAttributeAndValue(attributes[attributeNumber], values[attributeNumber]));
        }
        return result.toString();
    }

    protected String getStringOfAttributeAndValue(Attribute attribute, Object value) {
        return attribute.getName() + "=" + this.getStringOfValue(attribute, value);
    }

    protected String getStringOfAttributes(Attribute[] attributes) {
        StringBuffer result = new StringBuffer();
        for (int attributeNumber = 0; attributeNumber < attributes.length; ++attributeNumber) {
            if (attributeNumber > 0) {
                result.append(", ");
            }
            result.append(attributes[attributeNumber].getName());
        }
        return result.toString();
    }

    protected String getStringOfAttributesAndValues(Attribute[] attributes, Hashtable<String, Object> values) {
        StringBuffer result = new StringBuffer();
        for (int attributeNumber = 0; attributeNumber < attributes.length; ++attributeNumber) {
            if (attributeNumber > 0) {
                result.append(", ");
            }
            result.append(this.getStringOfAttributeAndValue(attributes[attributeNumber], values.get(attributes[attributeNumber].getName())));
        }
        return result.toString();
    }

    protected String getStringOfAttributesAndValues(Attribute[] attributes, Object[] values) {
        StringBuffer result = new StringBuffer();
        for (int attributeNumber = 0; attributeNumber < attributes.length; ++attributeNumber) {
            if (attributeNumber > 0) {
                result.append(", ");
            }
            result.append(this.getStringOfAttributeAndValue(attributes[attributeNumber], values[attributeNumber]));
        }
        return result.toString();
    }

    protected String getStringOfAttributesAndValuesExceptPrimaryKey(Attribute[] attributes, Hashtable<String, Object> values, Attribute[] primaryKey) {
        StringBuffer result = new StringBuffer();
        boolean firstAttribute = true;
        for (int attributeNumber = 0; attributeNumber < attributes.length; ++attributeNumber) {
            int primaryKeyAttributeNumber;
            for (primaryKeyAttributeNumber = 0; primaryKeyAttributeNumber < primaryKey.length && !attributes[attributeNumber].getName().equals(primaryKey[primaryKeyAttributeNumber].getName()); ++primaryKeyAttributeNumber) {
            }
            if (primaryKeyAttributeNumber < primaryKey.length) continue;
            if (firstAttribute) {
                firstAttribute = false;
            } else {
                result.append(", ");
            }
            result.append(this.getStringOfAttributeAndValue(attributes[attributeNumber], values.get(attributes[attributeNumber].getName())));
        }
        return result.toString();
    }

    protected String getStringOfValue(Attribute attribute, Object value) {
        if (value == null) {
            return "NULL";
        }
        String stringValue = value instanceof byte[] ? new String((byte[])value) : value.toString();
        switch (attribute.getType()) {
            case 1: 
            case 2: {
                return stringValue;
            }
            case 3: {
                return "'" + this.convertStringForDB(stringValue) + "'";
            }
        }
        throw new IllegalStateException("Unknown attribute type");
    }

    protected String getStringOfValues(Attribute[] attributes, Hashtable<String, Object> values) {
        StringBuffer result = new StringBuffer();
        for (int attributeNumber = 0; attributeNumber < attributes.length; ++attributeNumber) {
            if (attributeNumber > 0) {
                result.append(", ");
            }
            result.append(this.getStringOfValue(attributes[attributeNumber], values.get(attributes[attributeNumber].getName())));
        }
        return result.toString();
    }

    protected String getUpdateString(String tableName, Attribute[] attributes, Hashtable<String, Object> values, Attribute[] primaryKey) {
        StringBuffer update = new StringBuffer();
        update.append("update ");
        update.append(tableName);
        update.append(" set ");
        update.append(this.getStringOfAttributesAndValuesExceptPrimaryKey(attributes, values, primaryKey));
        String condition = this.getStringOfAndedAttributesAndValues(primaryKey, values);
        if (!condition.equals("")) {
            update.append(" where ");
            update.append(condition);
        }
        return update.toString();
    }

    protected void setUniquePrimaryKeyValueAfterInsert(Connection connection, Entity entity, Hashtable<String, Object> values) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUniquePrimaryKeyValueBeforeInsert(Connection connection, Entity entity, Hashtable<String, Object> values) throws SQLException {
        Attribute[] primaryKey = entity.getPrimaryKey();
        Class<?> clazz = entity.getClass();
        synchronized (clazz) {
            for (int attributeNumber = 0; attributeNumber < primaryKey.length; ++attributeNumber) {
                Statement statement = null;
                ResultSet resultSet = null;
                try {
                    StringBuffer query = new StringBuffer();
                    query.append("select max(");
                    query.append(primaryKey[attributeNumber].getName());
                    query.append(") from ");
                    query.append(entity.getTableName());
                    statement = connection.createStatement();
                    resultSet = statement.executeQuery(query.toString());
                    if (!resultSet.next()) continue;
                    entity.setValue(primaryKey[attributeNumber].getName(), resultSet.getInt(1) + 1);
                    continue;
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                        resultSet = null;
                    }
                    if (statement != null) {
                        statement.close();
                        statement = null;
                    }
                }
            }
        }
    }
}

