/*
 * Decompiled with CFR 0.152.
 */
package de.renew.application;

import de.renew.application.NoSimulationException;
import de.renew.application.SimulationEnvironment;
import de.renew.application.SimulationRunningException;
import de.renew.application.SimulatorExtension;
import de.renew.database.SetupHelper;
import de.renew.net.NetInstance;
import de.renew.net.NetNotFoundException;
import de.renew.net.loading.Finder;
import de.renew.net.loading.NetLoader;
import de.renew.net.loading.PathlessFinder;
import de.renew.shadow.ShadowLookup;
import de.renew.shadow.ShadowNetSystem;
import de.renew.shadow.SyntaxException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Properties;

public interface SimulatorManager {
    public static final String MODE_PROP_NAME = "de.renew.simulatorMode";
    public static final String PRIORITY_PROP_NAME = "de.renew.simulatorPriority";
    public static final String MULTIPLICITY_PROP_NAME = "de.renew.simulatorMultiplicity";
    public static final String CLASS_PROP_NAME = "de.renew.simulatorClass";
    public static final String EAGER_PROP_NAME = "de.renew.eagerSimulation";
    public static final String REINIT_PROP_NAME = "de.renew.classReinit";

    public void addExtension(SimulatorExtension var1);

    public void removeExtension(SimulatorExtension var1);

    public void setupSimulation(Properties var1);

    public void terminateSimulation();

    public boolean isSimulationActive();

    public SimulationEnvironment getCurrentEnvironment();

    public ShadowLookup insertNets(ShadowNetSystem var1) throws SyntaxException, NoSimulationException;

    public NetInstance createNetInstance(String var1) throws NetNotFoundException, NoSimulationException;

    public SetupHelper.SimulationState restoreStateFromDatabase();

    public void saveState(ObjectOutput var1, NetInstance[] var2) throws IOException;

    public NetInstance[] loadState(ObjectInput var1, Properties var2) throws IOException, ClassNotFoundException, SimulationRunningException;

    public void setNetLoader(NetLoader var1);

    public void possiblySetupClassSource(Properties var1) throws IllegalStateException;

    public void setDefaultNetLoader();

    public void registerDefaultNetFinder(Finder var1);

    public void removeDefaultNetFinder(Finder var1);

    public void registerDefaultPathlessFinder(PathlessFinder var1);

    public void removeDefaultPathlessFinder(PathlessFinder var1);
}

