/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.gui;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.MenuManager;
import CH.ifa.draw.util.Palette;
import de.renew.formalism.FormalismChangeListener;
import de.renew.formalism.FormalismPlugin;
import de.renew.formalism.gui.FormalismGuiCreator;
import de.renew.formalism.gui.JavaGuiCreator;
import de.renew.gui.GuiPlugin;
import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginException;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class FormalismGuiPlugin
extends PluginAdapter
implements FormalismChangeListener {
    public static final Logger LOGGER = Logger.getLogger(FormalismGuiPlugin.class);
    private Palette _currentPalette;
    private JMenuItem _currentMenu;
    private FormalismGuiCreator _currentCreator;
    private JMenu _formalismMenu;
    private Map<String, JMenuItem> _menuEntries = new HashMap<String, JMenuItem>();
    private MenuManager _menuManager;
    private Map<String, FormalismGuiCreator> _guicreators = new HashMap<String, FormalismGuiCreator>();

    public FormalismGuiPlugin(URL location) throws PluginException {
        super(location);
    }

    public FormalismGuiPlugin(PluginProperties props) {
        super(props);
    }

    public static FormalismGuiPlugin getCurrent() {
        for (IPlugin o : PluginManager.getInstance().getPlugins()) {
            if (!(o instanceof FormalismGuiPlugin)) continue;
            return (FormalismGuiPlugin)o;
        }
        return null;
    }

    public void init() {
        LOGGER.debug((Object)"initializing FormalismGui");
        JavaGuiCreator javaGuiCreator = new JavaGuiCreator();
        this._guicreators.put("Java Net Compiler", javaGuiCreator);
        this._guicreators.put("Timed Java Compiler", javaGuiCreator.getSequentialJavaGuiCreator());
        FormalismPlugin store = FormalismPlugin.getCurrent();
        store.addFormalismChangeListener((FormalismChangeListener)this);
        this._formalismMenu = this.createMenu();
        GuiPlugin starter = GuiPlugin.getCurrent();
        LOGGER.debug((Object)"adding menu");
        this._menuManager = DrawPlugin.getCurrent().getMenuManager();
        MenuManager.SeparatorFactory sepFac = new MenuManager.SeparatorFactory("de.renew.formalism.gui");
        this._menuManager.registerMenu("Simulation", sepFac.createSeparator());
        this._menuManager.registerMenu("Simulation", (JMenuItem)this._formalismMenu, "de.renew.formalism.gui.formalisms");
        if (starter == null) {
            LOGGER.debug((Object)"FormalismGuiPlugin: no GuiPlugin, could not add menu.");
        }
        this.formalismChosen(store.getCompiler());
    }

    public void addGuiConfigurator(String formalismName, FormalismGuiCreator creator) {
        boolean affectsCurrentFormalism;
        LOGGER.debug((Object)("Adding GUI configurator for " + formalismName));
        FormalismPlugin store = FormalismPlugin.getCurrent();
        String currentFormalism = store.getCompiler();
        boolean bl = affectsCurrentFormalism = currentFormalism != null && currentFormalism.equals(formalismName);
        if (affectsCurrentFormalism) {
            this.cleanGui();
        }
        this._guicreators.put(formalismName, creator);
        if (affectsCurrentFormalism) {
            this.createGuiItems(currentFormalism);
        }
    }

    public void removeGuiConfigurator(String formalismName) {
        boolean affectsCurrentFormalism;
        LOGGER.debug((Object)("Removing GUI configurator for " + formalismName));
        FormalismPlugin store = FormalismPlugin.getCurrent();
        String currentFormalism = store.getCompiler();
        boolean bl = affectsCurrentFormalism = currentFormalism != null && currentFormalism.equals(formalismName);
        if (affectsCurrentFormalism) {
            this.cleanGui();
        }
        this._guicreators.remove(formalismName);
    }

    private JMenu createMenu() {
        JMenu result = new JMenu("Formalisms");
        FormalismPlugin store = FormalismPlugin.getCurrent();
        Iterator formalisms = store.getKnownFormalisms();
        while (formalisms.hasNext()) {
            String current = (String)formalisms.next();
            final JCheckBoxMenuItem item = new JCheckBoxMenuItem(current);
            if (current.equals(store.getCompiler())) {
                item.setSelected(true);
            }
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String chosenCompiler = item.getText();
                    LOGGER.debug((Object)("compiler " + chosenCompiler + " has been chosen."));
                    FormalismGuiPlugin.this.formalismChosen(chosenCompiler);
                }
            });
            result.add(item);
        }
        return result;
    }

    private void formalismChosen(String chosenCompiler) {
        FormalismPlugin store = FormalismPlugin.getCurrent();
        store.setCompiler(chosenCompiler);
        this.selectFormalismItem(chosenCompiler);
        this.cleanGui();
        this.createGuiItems(chosenCompiler);
    }

    private void createGuiItems(String chosenCompiler) {
        GuiPlugin starter = GuiPlugin.getCurrent();
        this._currentCreator = this._guicreators.get(chosenCompiler);
        if (this._currentCreator != null) {
            this._currentPalette = this._currentCreator.createPalette();
            if (this._currentPalette != null) {
                starter.getPaletteHolder().addPalette(this._currentPalette);
            }
            this._currentMenu = this._currentCreator.createMenu();
            if (this._currentMenu != null) {
                this._menuManager.registerMenu("Simulation", this._currentMenu, "de.renew.formalism.gui.current");
            }
            this._currentCreator.formalismActivated();
        }
    }

    private void cleanGui() {
        GuiPlugin starter = GuiPlugin.getCurrent();
        if (this._currentCreator != null) {
            this._currentCreator.formalismDeactivated();
            this._currentCreator = null;
        }
        if (this._currentPalette != null) {
            starter.getPaletteHolder().removePalette(this._currentPalette);
            this._currentPalette = null;
        }
        if (this._currentMenu != null) {
            this._menuManager.unregisterMenu(this._currentMenu);
            this._currentMenu = null;
        }
    }

    private void selectFormalismItem(String chosenCompiler) {
        Component[] comps = this._formalismMenu.getMenuComponents();
        for (int i = 0; i < comps.length; ++i) {
            JCheckBoxMenuItem item = (JCheckBoxMenuItem)comps[i];
            boolean selectItem = item.getText().equals(chosenCompiler);
            item.setSelected(selectItem);
        }
    }

    public boolean cleanup() {
        FormalismPlugin store = FormalismPlugin.getCurrent();
        store.removeFormalismChangeListener((FormalismChangeListener)this);
        this.cleanGui();
        DrawPlugin.getCurrent().getMenuManager().unregisterMenu((JMenuItem)this._formalismMenu);
        this._formalismMenu = null;
        this._guicreators.clear();
        this._menuEntries.clear();
        this._menuManager = null;
        return true;
    }

    public void formalismChanged(String formalismName, Object name, int action) {
        if (action == 0) {
            LOGGER.debug((Object)("FormalismGuiPlugin: new formalism added: " + formalismName));
            final JCheckBoxMenuItem item = new JCheckBoxMenuItem(formalismName);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String chosenCompiler = item.getText();
                    LOGGER.debug((Object)("compiler " + chosenCompiler + " has been chosen."));
                    FormalismGuiPlugin.this.formalismChosen(chosenCompiler);
                }
            });
            this._formalismMenu.add(item);
            this._menuEntries.put(formalismName, item);
        } else if (action == 2) {
            LOGGER.debug((Object)("FormalismGuiPlugin: formalism chosen: " + formalismName));
            this.formalismChosen(formalismName);
        } else if (action == 1) {
            LOGGER.debug((Object)("FormalismGuiPlugin: formalism removed: " + formalismName));
            JMenuItem item = this._menuEntries.get(formalismName);
            if (item != null) {
                this._formalismMenu.remove(item);
                this._menuEntries.remove(formalismName);
            }
        }
    }
}

