/*
 * Decompiled with CFR 0.152.
 */
package de.renew.remote;

import de.renew.application.SimulationEnvironment;
import de.renew.engine.searcher.Searchable;
import de.renew.engine.searcher.TriggerCollection;
import de.renew.engine.searcher.TriggerCollectionImpl;
import de.renew.engine.searcher.Triggerable;
import de.renew.engine.simulator.Binding;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.engine.simulator.SimulatorHelper;
import de.renew.net.NetElementID;
import de.renew.net.TransitionInstance;
import de.renew.net.event.FiringEvent;
import de.renew.net.event.TransitionEventListener;
import de.renew.remote.BindingAccessor;
import de.renew.remote.BindingAccessorImpl;
import de.renew.remote.NetInstanceAccessor;
import de.renew.remote.NetInstanceAccessorImpl;
import de.renew.remote.ObjectAccessorImpl;
import de.renew.remote.RemoteEventListener;
import de.renew.remote.TransitionAccessor;
import de.renew.remote.TransitionAccessorImpl;
import de.renew.remote.TransitionInstanceAccessor;
import de.renew.remote.TriggerableForwarder;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class TransitionInstanceAccessorImpl
extends ObjectAccessorImpl
implements TransitionInstanceAccessor,
TransitionEventListener,
Triggerable {
    public static final Logger LOGGER = Logger.getLogger(TransitionInstanceAccessorImpl.class);
    private Set<RemoteEventListener> _firingListeners = Collections.synchronizedSet(new HashSet());
    private Set<TriggerableForwarder> _proposalListeners = Collections.synchronizedSet(new HashSet());
    private TriggerCollection _triggers = new TriggerCollectionImpl((Triggerable)this);

    public TransitionInstanceAccessorImpl(TransitionInstance transitionInstance, SimulationEnvironment environment) throws RemoteException {
        super(transitionInstance, environment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRemoteEventListener(RemoteEventListener listener) throws RemoteException {
        Set<RemoteEventListener> set = this._firingListeners;
        synchronized (set) {
            if (this._firingListeners.isEmpty()) {
                ((TransitionInstance)this._object).addTransitionEventListener((TransitionEventListener)this);
            }
            this._firingListeners.add(listener);
        }
    }

    @Override
    public BindingAccessor[] findAllBindings(final TriggerableForwarder triggerableForwarder) throws RemoteException {
        final TransitionInstanceAccessorImpl impl = this;
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<BindingAccessor[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public BindingAccessor[] call() throws Exception {
                BindingAccessor[] bindings;
                Set<TriggerableForwarder> set = TransitionInstanceAccessorImpl.this._proposalListeners;
                synchronized (set) {
                    TransitionInstanceAccessorImpl.this._proposalListeners.add(triggerableForwarder);
                }
                try {
                    TransitionInstanceAccessorImpl.this._triggers.clear();
                    Collection allBindings = SimulatorHelper.findAllBindings((Searchable)((TransitionInstance)TransitionInstanceAccessorImpl.this._object), (Triggerable)impl);
                    Iterator iter = allBindings.iterator();
                    bindings = new BindingAccessor[allBindings.size()];
                    int i = 0;
                    while (iter.hasNext()) {
                        bindings[i] = new BindingAccessorImpl((Binding)iter.next(), TransitionInstanceAccessorImpl.this.getEnvironment());
                        ++i;
                    }
                }
                catch (RemoteException e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                    bindings = new BindingAccessor[]{};
                }
                return bindings;
            }
        });
        try {
            return (BindingAccessor[])future.get();
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)e);
        }
        catch (ExecutionException e) {
            LOGGER.error((Object)"Simulation thread threw an exception", (Throwable)e);
        }
        return null;
    }

    @Override
    public void forgetBindings(final TriggerableForwarder triggerableForwarder) throws RemoteException {
        SimulationThreadPool.getCurrent().executeAndWait(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Set<TriggerableForwarder> set = TransitionInstanceAccessorImpl.this._proposalListeners;
                synchronized (set) {
                    TransitionInstanceAccessorImpl.this._proposalListeners.remove(triggerableForwarder);
                    if (TransitionInstanceAccessorImpl.this._proposalListeners.isEmpty()) {
                        TransitionInstanceAccessorImpl.this._triggers.clear();
                    }
                }
            }
        });
    }

    @Override
    public boolean fireOneBinding() throws RemoteException {
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                boolean asynchronous = !TransitionInstanceAccessorImpl.this.getEnvironment().getSimulator().isSequential();
                return ((TransitionInstance)TransitionInstanceAccessorImpl.this._object).fireOneBinding(asynchronous);
            }
        });
        try {
            return (Boolean)future.get();
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)e);
        }
        catch (ExecutionException e) {
            LOGGER.error((Object)"Simulation thread threw an exception", (Throwable)e);
        }
        return false;
    }

    private void fireRemoteEvent() {
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws Exception {
                Set<RemoteEventListener> set = TransitionInstanceAccessorImpl.this._firingListeners;
                synchronized (set) {
                    for (RemoteEventListener listener : TransitionInstanceAccessorImpl.this._firingListeners) {
                        try {
                            listener.update();
                        }
                        catch (RemoteException e) {
                            LOGGER.error((Object)("TransitionInstanceAccessor: Remote event to " + String.valueOf(listener) + " probably got lost due to " + String.valueOf(e)));
                        }
                    }
                }
                return null;
            }
        });
        try {
            future.get();
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)e);
        }
        catch (ExecutionException e) {
            LOGGER.error((Object)"Simulation thread threw an exception", (Throwable)e);
        }
    }

    public void firingComplete(FiringEvent event) {
        this.fireRemoteEvent();
    }

    public void firingStarted(FiringEvent event) {
        this.fireRemoteEvent();
    }

    @Override
    public NetElementID getID() throws RemoteException {
        return ((TransitionInstance)this._object).getTransition().getID();
    }

    @Override
    public TransitionAccessor getTransition() throws RemoteException {
        return new TransitionAccessorImpl(((TransitionInstance)this._object).getTransition(), this.getEnvironment());
    }

    public TransitionInstance getTransitionInstance() {
        return (TransitionInstance)this._object;
    }

    @Override
    public NetInstanceAccessor getNetInstance() throws RemoteException {
        return new NetInstanceAccessorImpl(((TransitionInstance)this._object).getNetInstance(), this.getEnvironment());
    }

    @Override
    public boolean isFiring() throws RemoteException {
        return ((TransitionInstance)this._object).isFiring();
    }

    public synchronized void proposeSearch() {
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws Exception {
                ArrayList<TriggerableForwarder> triggerableForwarders;
                Set<TriggerableForwarder> set = TransitionInstanceAccessorImpl.this._proposalListeners;
                synchronized (set) {
                    triggerableForwarders = new ArrayList<TriggerableForwarder>(TransitionInstanceAccessorImpl.this._proposalListeners);
                    TransitionInstanceAccessorImpl.this._proposalListeners.clear();
                    TransitionInstanceAccessorImpl.this._triggers.clear();
                }
                Iterator i = triggerableForwarders.iterator();
                while (i.hasNext()) {
                    TriggerableForwarder forwarder = null;
                    try {
                        forwarder = (TriggerableForwarder)i.next();
                        forwarder.proposeSearch();
                    }
                    catch (RemoteException e) {
                        LOGGER.error((Object)("TransitionInstanceAccessor: Search proposal to " + String.valueOf(forwarder) + " probably got lost due to " + String.valueOf(e)));
                    }
                }
                return null;
            }
        });
        try {
            future.get();
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)e);
        }
        catch (ExecutionException e) {
            LOGGER.error((Object)"Simulation thread threw an exception", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRemoteEventListener(RemoteEventListener listener) throws RemoteException {
        Set<RemoteEventListener> set = this._firingListeners;
        synchronized (set) {
            this._firingListeners.remove(listener);
            if (this._firingListeners.isEmpty()) {
                ((TransitionInstance)this._object).removeTransitionEventListener((TransitionEventListener)this);
            }
        }
    }

    public TriggerCollection triggers() {
        return this._triggers;
    }

    public boolean wantSynchronousNotification() {
        return false;
    }
}

